/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.simspaceweaver.model.AccessDeniedException;
import software.amazon.awssdk.services.simspaceweaver.model.ConflictException;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.InternalServerException;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ResourceNotFoundException;
import software.amazon.awssdk.services.simspaceweaver.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.simspaceweaver.model.SimSpaceWeaverException;
import software.amazon.awssdk.services.simspaceweaver.model.StartAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StartClockRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartClockResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StartSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopClockRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopClockResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.TagResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.TagResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.model.TooManyTagsException;
import software.amazon.awssdk.services.simspaceweaver.model.UntagResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.UntagResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ValidationException;
import software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable;
import software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable;

/**
 * Service client for accessing AWS SimSpace Weaver. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services SimSpace Weaver (SimSpace Weaver) is a managed service that you can use to build and operate
 * large-scale spatial simulations in the Amazon Web Services Cloud. For example, you can create a digital twin of a
 * city, crowd simulations with millions of people and objects, and massilvely-multiplayer games with hundreds of
 * thousands of connected players. For more information about SimSpace Weaver, see the <i> <a
 * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/">Amazon Web Services SimSpace Weaver User
 * Guide</a> </i>.
 * </p>
 * <p>
 * This API reference describes the API operations and data types that you can use to communicate directly with SimSpace
 * Weaver.
 * </p>
 * <p>
 * SimSpace Weaver also provides the SimSpace Weaver app SDK, which you use for app development. The SimSpace Weaver app
 * SDK API reference is included in the SimSpace Weaver app SDK documentation, which is part of the SimSpace Weaver app
 * SDK distributable package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SimSpaceWeaverClient extends AwsClient {
    String SERVICE_NAME = "simspaceweaver";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "simspaceweaver";

    /**
     * <p>
     * Deletes the instance of the given custom app.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the instance of the given custom app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppInput.Builder} to create a request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes all SimSpace Weaver resources assigned to the given simulation.
     * </p>
     * <note>
     * <p>
     * Your simulation uses resources in other Amazon Web Services services. This API operation doesn't delete resources
     * in other Amazon Web Services services.
     * </p>
     * </note>
     *
     * @param deleteSimulationRequest
     * @return Result of the DeleteSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DeleteSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSimulationResponse deleteSimulation(DeleteSimulationRequest deleteSimulationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all SimSpace Weaver resources assigned to the given simulation.
     * </p>
     * <note>
     * <p>
     * Your simulation uses resources in other Amazon Web Services services. This API operation doesn't delete resources
     * in other Amazon Web Services services.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSimulationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSimulationRequest#builder()}
     * </p>
     *
     * @param deleteSimulationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSimulationInput.Builder} to create a request.
     * @return Result of the DeleteSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DeleteSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSimulationResponse deleteSimulation(Consumer<DeleteSimulationRequest.Builder> deleteSimulationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return deleteSimulation(DeleteSimulationRequest.builder().applyMutation(deleteSimulationRequest).build());
    }

    /**
     * <p>
     * Returns the state of the given custom app.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the state of the given custom app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAppRequest#builder()}
     * </p>
     *
     * @param describeAppRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppInput.Builder} to create a request.
     * @return Result of the DescribeApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAppResponse describeApp(Consumer<DescribeAppRequest.Builder> describeAppRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return describeApp(DescribeAppRequest.builder().applyMutation(describeAppRequest).build());
    }

    /**
     * <p>
     * Returns the current state of the given simulation.
     * </p>
     *
     * @param describeSimulationRequest
     * @return Result of the DescribeSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DescribeSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationResponse describeSimulation(DescribeSimulationRequest describeSimulationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current state of the given simulation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSimulationRequest#builder()}
     * </p>
     *
     * @param describeSimulationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationInput.Builder} to create a request.
     * @return Result of the DescribeSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.DescribeSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationResponse describeSimulation(Consumer<DescribeSimulationRequest.Builder> describeSimulationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return describeSimulation(DescribeSimulationRequest.builder().applyMutation(describeSimulationRequest).build());
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws ResourceNotFoundException, InternalServerException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsInput.Builder} to create a request.
     * @return Result of the ListApps operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(ListAppsRequest listAppsRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(Consumer<ListAppsRequest.Builder> listAppsRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return listAppsPaginator(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     *
     * @param listSimulationsRequest
     * @return Result of the ListSimulations operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsResponse listSimulations(ListSimulationsRequest listSimulationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSimulationsRequest#builder()}
     * </p>
     *
     * @param listSimulationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationsInput.Builder} to create a request.
     * @return Result of the ListSimulations operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsResponse listSimulations(Consumer<ListSimulationsRequest.Builder> listSimulationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        return listSimulations(ListSimulationsRequest.builder().applyMutation(listSimulationsRequest).build());
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client.listSimulationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client
     *             .listSimulationsPaginator(request);
     *     for (software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client.listSimulationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsIterable listSimulationsPaginator(ListSimulationsRequest listSimulationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client.listSimulationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client
     *             .listSimulationsPaginator(request);
     *     for (software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsIterable responses = client.listSimulationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSimulationsRequest#builder()}
     * </p>
     *
     * @param listSimulationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsIterable listSimulationsPaginator(Consumer<ListSimulationsRequest.Builder> listSimulationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        return listSimulationsPaginator(ListSimulationsRequest.builder().applyMutation(listSimulationsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a SimSpace Weaver resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a SimSpace Weaver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a custom app with the configuration specified in the simulation schema.
     * </p>
     *
     * @param startAppRequest
     * @return Result of the StartApp operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp" target="_top">AWS API
     *      Documentation</a>
     */
    default StartAppResponse startApp(StartAppRequest startAppRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a custom app with the configuration specified in the simulation schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAppRequest.Builder} avoiding the need to
     * create one manually via {@link StartAppRequest#builder()}
     * </p>
     *
     * @param startAppRequest
     *        A {@link Consumer} that will call methods on {@link StartAppInput.Builder} to create a request.
     * @return Result of the StartApp operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp" target="_top">AWS API
     *      Documentation</a>
     */
    default StartAppResponse startApp(Consumer<StartAppRequest.Builder> startAppRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        return startApp(StartAppRequest.builder().applyMutation(startAppRequest).build());
    }

    /**
     * <p>
     * Starts the simulation clock.
     * </p>
     *
     * @param startClockRequest
     * @return Result of the StartClock operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock" target="_top">AWS API
     *      Documentation</a>
     */
    default StartClockResponse startClock(StartClockRequest startClockRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the simulation clock.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartClockRequest.Builder} avoiding the need to
     * create one manually via {@link StartClockRequest#builder()}
     * </p>
     *
     * @param startClockRequest
     *        A {@link Consumer} that will call methods on {@link StartClockInput.Builder} to create a request.
     * @return Result of the StartClock operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock" target="_top">AWS API
     *      Documentation</a>
     */
    default StartClockResponse startClock(Consumer<StartClockRequest.Builder> startClockRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return startClock(StartClockRequest.builder().applyMutation(startClockRequest).build());
    }

    /**
     * <p>
     * Starts a simulation with the given name and schema.
     * </p>
     *
     * @param startSimulationRequest
     * @return Result of the StartSimulation operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSimulationResponse startSimulation(StartSimulationRequest startSimulationRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a simulation with the given name and schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSimulationRequest.Builder} avoiding the need
     * to create one manually via {@link StartSimulationRequest#builder()}
     * </p>
     *
     * @param startSimulationRequest
     *        A {@link Consumer} that will call methods on {@link StartSimulationInput.Builder} to create a request.
     * @return Result of the StartSimulation operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ServiceQuotaExceededException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StartSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSimulationResponse startSimulation(Consumer<StartSimulationRequest.Builder> startSimulationRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return startSimulation(StartSimulationRequest.builder().applyMutation(startSimulationRequest).build());
    }

    /**
     * <p>
     * Stops the given custom app and shuts down all of its allocated compute resources.
     * </p>
     *
     * @param stopAppRequest
     * @return Result of the StopApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp" target="_top">AWS API
     *      Documentation</a>
     */
    default StopAppResponse stopApp(StopAppRequest stopAppRequest) throws ResourceNotFoundException, InternalServerException,
            AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the given custom app and shuts down all of its allocated compute resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAppRequest.Builder} avoiding the need to create
     * one manually via {@link StopAppRequest#builder()}
     * </p>
     *
     * @param stopAppRequest
     *        A {@link Consumer} that will call methods on {@link StopAppInput.Builder} to create a request.
     * @return Result of the StopApp operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp" target="_top">AWS API
     *      Documentation</a>
     */
    default StopAppResponse stopApp(Consumer<StopAppRequest.Builder> stopAppRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        return stopApp(StopAppRequest.builder().applyMutation(stopAppRequest).build());
    }

    /**
     * <p>
     * Stops the simulation clock.
     * </p>
     *
     * @param stopClockRequest
     * @return Result of the StopClock operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock" target="_top">AWS API
     *      Documentation</a>
     */
    default StopClockResponse stopClock(StopClockRequest stopClockRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the simulation clock.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopClockRequest.Builder} avoiding the need to
     * create one manually via {@link StopClockRequest#builder()}
     * </p>
     *
     * @param stopClockRequest
     *        A {@link Consumer} that will call methods on {@link StopClockInput.Builder} to create a request.
     * @return Result of the StopClock operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock" target="_top">AWS API
     *      Documentation</a>
     */
    default StopClockResponse stopClock(Consumer<StopClockRequest.Builder> stopClockRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        return stopClock(StopClockRequest.builder().applyMutation(stopClockRequest).build());
    }

    /**
     * <p>
     * Stops the given simulation.
     * </p>
     * <important>
     * <p>
     * You can't restart a simulation after you stop it. If you need to restart a simulation, you must stop it, delete
     * it, and start a new instance of it.
     * </p>
     * </important>
     *
     * @param stopSimulationRequest
     * @return Result of the StopSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation" target="_top">AWS
     *      API Documentation</a>
     */
    default StopSimulationResponse stopSimulation(StopSimulationRequest stopSimulationRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the given simulation.
     * </p>
     * <important>
     * <p>
     * You can't restart a simulation after you stop it. If you need to restart a simulation, you must stop it, delete
     * it, and start a new instance of it.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSimulationRequest.Builder} avoiding the need to
     * create one manually via {@link StopSimulationRequest#builder()}
     * </p>
     *
     * @param stopSimulationRequest
     *        A {@link Consumer} that will call methods on {@link StopSimulationInput.Builder} to create a request.
     * @return Result of the StopSimulation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.StopSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation" target="_top">AWS
     *      API Documentation</a>
     */
    default StopSimulationResponse stopSimulation(Consumer<StopSimulationRequest.Builder> stopSimulationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return stopSimulation(StopSimulationRequest.builder().applyMutation(stopSimulationRequest).build());
    }

    /**
     * <p>
     * Adds tags to a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws TooManyTagsException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, SimSpaceWeaverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SimSpaceWeaverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SimSpaceWeaverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SimSpaceWeaverException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link SimSpaceWeaverClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SimSpaceWeaverClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SimSpaceWeaverClient}.
     */
    static SimSpaceWeaverClientBuilder builder() {
        return new DefaultSimSpaceWeaverClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SimSpaceWeaverServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
