/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.swf.model.WorkflowType;

@SdkInternalApi
public class WorkflowTypeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final WorkflowTypeMarshaller instance = new WorkflowTypeMarshaller();

    public static WorkflowTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkflowType workflowType, ProtocolMarshaller protocolMarshaller) {
        if (workflowType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workflowType.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)workflowType.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

