/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.model.HistoryEvent;

@SdkInternalApi
public class HistoryEventMarshaller {
    private static final MarshallingInfo<Date> EVENTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTimestamp").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<Long> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> COMPLETEWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completeWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> FAILWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CANCELWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cancelWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCONTINUEDASNEWEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionContinuedAsNewEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CONTINUEASNEWWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("continueAsNewWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionTerminatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("decisionTaskScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("decisionTaskStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("decisionTaskCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("decisionTaskTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTaskCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowExecutionSignaledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> MARKERRECORDEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("markerRecordedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> RECORDMARKERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordMarkerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timerStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERFIREDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timerFiredEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timerCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTCHILDWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startChildWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childWorkflowExecutionTerminatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SIGNALEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signalExternalWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> EXTERNALWORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalWorkflowExecutionSignaledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SIGNALEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signalExternalWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> EXTERNALWORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalWorkflowExecutionCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestCancelExternalWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestCancelExternalWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULEACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduleActivityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestCancelActivityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTTIMERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CANCELTIMERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cancelTimerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTCHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startChildWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULELAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduleLambdaFunctionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTLAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startLambdaFunctionFailedEventAttributes").build();
    private static final HistoryEventMarshaller instance = new HistoryEventMarshaller();

    public static HistoryEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(HistoryEvent historyEvent, ProtocolMarshaller protocolMarshaller) {
        if (historyEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)historyEvent.eventTimestamp(), EVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.eventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.eventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionStartedEventAttributes(), WORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionCompletedEventAttributes(), WORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.completeWorkflowExecutionFailedEventAttributes(), COMPLETEWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionFailedEventAttributes(), WORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.failWorkflowExecutionFailedEventAttributes(), FAILWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionTimedOutEventAttributes(), WORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionCanceledEventAttributes(), WORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.cancelWorkflowExecutionFailedEventAttributes(), CANCELWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionContinuedAsNewEventAttributes(), WORKFLOWEXECUTIONCONTINUEDASNEWEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.continueAsNewWorkflowExecutionFailedEventAttributes(), CONTINUEASNEWWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionTerminatedEventAttributes(), WORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionCancelRequestedEventAttributes(), WORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.decisionTaskScheduledEventAttributes(), DECISIONTASKSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.decisionTaskStartedEventAttributes(), DECISIONTASKSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.decisionTaskCompletedEventAttributes(), DECISIONTASKCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.decisionTaskTimedOutEventAttributes(), DECISIONTASKTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskScheduledEventAttributes(), ACTIVITYTASKSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskStartedEventAttributes(), ACTIVITYTASKSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskCompletedEventAttributes(), ACTIVITYTASKCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskFailedEventAttributes(), ACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskTimedOutEventAttributes(), ACTIVITYTASKTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskCanceledEventAttributes(), ACTIVITYTASKCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTaskCancelRequestedEventAttributes(), ACTIVITYTASKCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.workflowExecutionSignaledEventAttributes(), WORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.markerRecordedEventAttributes(), MARKERRECORDEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.recordMarkerFailedEventAttributes(), RECORDMARKERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.timerStartedEventAttributes(), TIMERSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.timerFiredEventAttributes(), TIMERFIREDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.timerCanceledEventAttributes(), TIMERCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.startChildWorkflowExecutionInitiatedEventAttributes(), STARTCHILDWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionStartedEventAttributes(), CHILDWORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionCompletedEventAttributes(), CHILDWORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionFailedEventAttributes(), CHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionTimedOutEventAttributes(), CHILDWORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionCanceledEventAttributes(), CHILDWORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.childWorkflowExecutionTerminatedEventAttributes(), CHILDWORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.signalExternalWorkflowExecutionInitiatedEventAttributes(), SIGNALEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.externalWorkflowExecutionSignaledEventAttributes(), EXTERNALWORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.signalExternalWorkflowExecutionFailedEventAttributes(), SIGNALEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.externalWorkflowExecutionCancelRequestedEventAttributes(), EXTERNALWORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.requestCancelExternalWorkflowExecutionInitiatedEventAttributes(), REQUESTCANCELEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.requestCancelExternalWorkflowExecutionFailedEventAttributes(), REQUESTCANCELEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.scheduleActivityTaskFailedEventAttributes(), SCHEDULEACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.requestCancelActivityTaskFailedEventAttributes(), REQUESTCANCELACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.startTimerFailedEventAttributes(), STARTTIMERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.cancelTimerFailedEventAttributes(), CANCELTIMERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.startChildWorkflowExecutionFailedEventAttributes(), STARTCHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionScheduledEventAttributes(), LAMBDAFUNCTIONSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionStartedEventAttributes(), LAMBDAFUNCTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionCompletedEventAttributes(), LAMBDAFUNCTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionFailedEventAttributes(), LAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionTimedOutEventAttributes(), LAMBDAFUNCTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.scheduleLambdaFunctionFailedEventAttributes(), SCHEDULELAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.startLambdaFunctionFailedEventAttributes(), STARTLAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

