/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionStartedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WorkflowExecutionStartedEventAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
    private final String input;
    private final String executionStartToCloseTimeout;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final TaskList taskList;
    private final WorkflowType workflowType;
    private final List<String> tagList;
    private final String taskPriority;
    private final String continuedExecutionRunId;
    private final WorkflowExecution parentWorkflowExecution;
    private final Long parentInitiatedEventId;
    private final String lambdaRole;

    private WorkflowExecutionStartedEventAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.taskList = builder.taskList;
        this.workflowType = builder.workflowType;
        this.tagList = builder.tagList;
        this.taskPriority = builder.taskPriority;
        this.continuedExecutionRunId = builder.continuedExecutionRunId;
        this.parentWorkflowExecution = builder.parentWorkflowExecution;
        this.parentInitiatedEventId = builder.parentInitiatedEventId;
        this.lambdaRole = builder.lambdaRole;
    }

    public String input() {
        return this.input;
    }

    public String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public String childPolicy() {
        return this.childPolicy;
    }

    public TaskList taskList() {
        return this.taskList;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public String taskPriority() {
        return this.taskPriority;
    }

    public String continuedExecutionRunId() {
        return this.continuedExecutionRunId;
    }

    public WorkflowExecution parentWorkflowExecution() {
        return this.parentWorkflowExecution;
    }

    public Long parentInitiatedEventId() {
        return this.parentInitiatedEventId;
    }

    public String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.input() == null ? 0 : this.input().hashCode());
        hashCode = 31 * hashCode + (this.executionStartToCloseTimeout() == null ? 0 : this.executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + (this.taskStartToCloseTimeout() == null ? 0 : this.taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + (this.childPolicy() == null ? 0 : this.childPolicy().hashCode());
        hashCode = 31 * hashCode + (this.taskList() == null ? 0 : this.taskList().hashCode());
        hashCode = 31 * hashCode + (this.workflowType() == null ? 0 : this.workflowType().hashCode());
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        hashCode = 31 * hashCode + (this.taskPriority() == null ? 0 : this.taskPriority().hashCode());
        hashCode = 31 * hashCode + (this.continuedExecutionRunId() == null ? 0 : this.continuedExecutionRunId().hashCode());
        hashCode = 31 * hashCode + (this.parentWorkflowExecution() == null ? 0 : this.parentWorkflowExecution().hashCode());
        hashCode = 31 * hashCode + (this.parentInitiatedEventId() == null ? 0 : this.parentInitiatedEventId().hashCode());
        hashCode = 31 * hashCode + (this.lambdaRole() == null ? 0 : this.lambdaRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionStartedEventAttributes)) {
            return false;
        }
        WorkflowExecutionStartedEventAttributes other = (WorkflowExecutionStartedEventAttributes)obj;
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.continuedExecutionRunId() == null ^ this.continuedExecutionRunId() == null) {
            return false;
        }
        if (other.continuedExecutionRunId() != null && !other.continuedExecutionRunId().equals(this.continuedExecutionRunId())) {
            return false;
        }
        if (other.parentWorkflowExecution() == null ^ this.parentWorkflowExecution() == null) {
            return false;
        }
        if (other.parentWorkflowExecution() != null && !other.parentWorkflowExecution().equals(this.parentWorkflowExecution())) {
            return false;
        }
        if (other.parentInitiatedEventId() == null ^ this.parentInitiatedEventId() == null) {
            return false;
        }
        if (other.parentInitiatedEventId() != null && !other.parentInitiatedEventId().equals(this.parentInitiatedEventId())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        return other.lambdaRole() == null || other.lambdaRole().equals(this.lambdaRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.input() != null) {
            sb.append("Input: ").append(this.input()).append(",");
        }
        if (this.executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(this.executionStartToCloseTimeout()).append(",");
        }
        if (this.taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(this.taskStartToCloseTimeout()).append(",");
        }
        if (this.childPolicy() != null) {
            sb.append("ChildPolicy: ").append(this.childPolicy()).append(",");
        }
        if (this.taskList() != null) {
            sb.append("TaskList: ").append(this.taskList()).append(",");
        }
        if (this.workflowType() != null) {
            sb.append("WorkflowType: ").append(this.workflowType()).append(",");
        }
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        if (this.taskPriority() != null) {
            sb.append("TaskPriority: ").append(this.taskPriority()).append(",");
        }
        if (this.continuedExecutionRunId() != null) {
            sb.append("ContinuedExecutionRunId: ").append(this.continuedExecutionRunId()).append(",");
        }
        if (this.parentWorkflowExecution() != null) {
            sb.append("ParentWorkflowExecution: ").append(this.parentWorkflowExecution()).append(",");
        }
        if (this.parentInitiatedEventId() != null) {
            sb.append("ParentInitiatedEventId: ").append(this.parentInitiatedEventId()).append(",");
        }
        if (this.lambdaRole() != null) {
            sb.append("LambdaRole: ").append(this.lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionStartedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String input;
        private String executionStartToCloseTimeout;
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private TaskList taskList;
        private WorkflowType workflowType;
        private List<String> tagList;
        private String taskPriority;
        private String continuedExecutionRunId;
        private WorkflowExecution parentWorkflowExecution;
        private Long parentInitiatedEventId;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionStartedEventAttributes model) {
            this.setInput(model.input);
            this.setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.setChildPolicy(model.childPolicy);
            this.setTaskList(model.taskList);
            this.setWorkflowType(model.workflowType);
            this.setTagList(model.tagList);
            this.setTaskPriority(model.taskPriority);
            this.setContinuedExecutionRunId(model.continuedExecutionRunId);
            this.setParentWorkflowExecution(model.parentWorkflowExecution);
            this.setParentInitiatedEventId(model.parentInitiatedEventId);
            this.setLambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final TaskList getTaskList() {
            return this.taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final WorkflowType getWorkflowType() {
            return this.workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getContinuedExecutionRunId() {
            return this.continuedExecutionRunId;
        }

        @Override
        public final Builder continuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
            return this;
        }

        public final void setContinuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
        }

        public final WorkflowExecution getParentWorkflowExecution() {
            return this.parentWorkflowExecution;
        }

        @Override
        public final Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
            return this;
        }

        public final void setParentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
        }

        public final Long getParentInitiatedEventId() {
            return this.parentInitiatedEventId;
        }

        @Override
        public final Builder parentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
            return this;
        }

        public final void setParentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        public WorkflowExecutionStartedEventAttributes build() {
            return new WorkflowExecutionStartedEventAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder taskList(TaskList var1);

        public Builder workflowType(WorkflowType var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder taskPriority(String var1);

        public Builder continuedExecutionRunId(String var1);

        public Builder parentWorkflowExecution(WorkflowExecution var1);

        public Builder parentInitiatedEventId(Long var1);

        public Builder lambdaRole(String var1);
    }
}

