/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.swf.model.DomainInfo;
import software.amazon.awssdk.services.swf.model.DomainInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private final List<DomainInfo> domainInfos;
    private final String nextPageToken;

    private ListDomainsResponse(BuilderImpl builder) {
        this.domainInfos = builder.domainInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<DomainInfo> domainInfos() {
        return this.domainInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainInfos() == null ? 0 : this.domainInfos().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        if (other.domainInfos() == null ^ this.domainInfos() == null) {
            return false;
        }
        if (other.domainInfos() != null && !other.domainInfos().equals(this.domainInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainInfos() != null) {
            sb.append("DomainInfos: ").append(this.domainInfos()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DomainInfo> domainInfos;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            this.setDomainInfos(model.domainInfos);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<DomainInfo> getDomainInfos() {
            return this.domainInfos;
        }

        @Override
        public final Builder domainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(DomainInfo ... domainInfos) {
            if (this.domainInfos == null) {
                this.domainInfos = new ArrayList<DomainInfo>(domainInfos.length);
            }
            for (DomainInfo e : domainInfos) {
                this.domainInfos.add(e);
            }
            return this;
        }

        public final void setDomainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
        }

        @SafeVarargs
        public final void setDomainInfos(DomainInfo ... domainInfos) {
            if (this.domainInfos == null) {
                this.domainInfos = new ArrayList<DomainInfo>(domainInfos.length);
            }
            for (DomainInfo e : domainInfos) {
                this.domainInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domainInfos(Collection<DomainInfo> var1);

        public Builder domainInfos(DomainInfo ... var1);

        public Builder nextPageToken(String var1);
    }
}

