/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.HistoryEventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetWorkflowExecutionHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetWorkflowExecutionHistoryResponse> {
    private final List<HistoryEvent> events;
    private final String nextPageToken;

    private GetWorkflowExecutionHistoryResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<HistoryEvent> events() {
        return this.events;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowExecutionHistoryResponse)) {
            return false;
        }
        GetWorkflowExecutionHistoryResponse other = (GetWorkflowExecutionHistoryResponse)((Object)obj);
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HistoryEvent> events;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowExecutionHistoryResponse model) {
            this.setEvents(model.events);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<HistoryEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent ... events) {
            if (this.events == null) {
                this.events = new ArrayList<HistoryEvent>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(HistoryEvent ... events) {
            if (this.events == null) {
                this.events = new ArrayList<HistoryEvent>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetWorkflowExecutionHistoryResponse build() {
            return new GetWorkflowExecutionHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetWorkflowExecutionHistoryResponse> {
        public Builder events(Collection<HistoryEvent> var1);

        public Builder events(HistoryEvent ... var1);

        public Builder nextPageToken(String var1);
    }
}

