/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.ExecutionTimeFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExecutionTimeFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, ExecutionTimeFilter> {
    private final Date oldestDate;
    private final Date latestDate;

    private ExecutionTimeFilter(BuilderImpl builder) {
        this.oldestDate = builder.oldestDate;
        this.latestDate = builder.latestDate;
    }

    public Date oldestDate() {
        return this.oldestDate;
    }

    public Date latestDate() {
        return this.latestDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.oldestDate() == null ? 0 : this.oldestDate().hashCode());
        hashCode = 31 * hashCode + (this.latestDate() == null ? 0 : this.latestDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTimeFilter)) {
            return false;
        }
        ExecutionTimeFilter other = (ExecutionTimeFilter)obj;
        if (other.oldestDate() == null ^ this.oldestDate() == null) {
            return false;
        }
        if (other.oldestDate() != null && !other.oldestDate().equals(this.oldestDate())) {
            return false;
        }
        if (other.latestDate() == null ^ this.latestDate() == null) {
            return false;
        }
        return other.latestDate() == null || other.latestDate().equals(this.latestDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.oldestDate() != null) {
            sb.append("OldestDate: ").append(this.oldestDate()).append(",");
        }
        if (this.latestDate() != null) {
            sb.append("LatestDate: ").append(this.latestDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionTimeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date oldestDate;
        private Date latestDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTimeFilter model) {
            this.setOldestDate(model.oldestDate);
            this.setLatestDate(model.latestDate);
        }

        public final Date getOldestDate() {
            return this.oldestDate;
        }

        @Override
        public final Builder oldestDate(Date oldestDate) {
            this.oldestDate = StandardMemberCopier.copy((Date)oldestDate);
            return this;
        }

        public final void setOldestDate(Date oldestDate) {
            this.oldestDate = StandardMemberCopier.copy((Date)oldestDate);
        }

        public final Date getLatestDate() {
            return this.latestDate;
        }

        @Override
        public final Builder latestDate(Date latestDate) {
            this.latestDate = StandardMemberCopier.copy((Date)latestDate);
            return this;
        }

        public final void setLatestDate(Date latestDate) {
            this.latestDate = StandardMemberCopier.copy((Date)latestDate);
        }

        public ExecutionTimeFilter build() {
            return new ExecutionTimeFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutionTimeFilter> {
        public Builder oldestDate(Date var1);

        public Builder latestDate(Date var1);
    }
}

