/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.DecisionTaskCompletedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecisionTaskCompletedEventAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, DecisionTaskCompletedEventAttributes> {
    private final String executionContext;
    private final Long scheduledEventId;
    private final Long startedEventId;

    private DecisionTaskCompletedEventAttributes(BuilderImpl builder) {
        this.executionContext = builder.executionContext;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    public String executionContext() {
        return this.executionContext;
    }

    public Long scheduledEventId() {
        return this.scheduledEventId;
    }

    public Long startedEventId() {
        return this.startedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.executionContext() == null ? 0 : this.executionContext().hashCode());
        hashCode = 31 * hashCode + (this.scheduledEventId() == null ? 0 : this.scheduledEventId().hashCode());
        hashCode = 31 * hashCode + (this.startedEventId() == null ? 0 : this.startedEventId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskCompletedEventAttributes)) {
            return false;
        }
        DecisionTaskCompletedEventAttributes other = (DecisionTaskCompletedEventAttributes)obj;
        if (other.executionContext() == null ^ this.executionContext() == null) {
            return false;
        }
        if (other.executionContext() != null && !other.executionContext().equals(this.executionContext())) {
            return false;
        }
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        return other.startedEventId() == null || other.startedEventId().equals(this.startedEventId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.executionContext() != null) {
            sb.append("ExecutionContext: ").append(this.executionContext()).append(",");
        }
        if (this.scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(this.scheduledEventId()).append(",");
        }
        if (this.startedEventId() != null) {
            sb.append("StartedEventId: ").append(this.startedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DecisionTaskCompletedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String executionContext;
        private Long scheduledEventId;
        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskCompletedEventAttributes model) {
            this.setExecutionContext(model.executionContext);
            this.setScheduledEventId(model.scheduledEventId);
            this.setStartedEventId(model.startedEventId);
        }

        public final String getExecutionContext() {
            return this.executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        public final Long getScheduledEventId() {
            return this.scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public DecisionTaskCompletedEventAttributes build() {
            return new DecisionTaskCompletedEventAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DecisionTaskCompletedEventAttributes> {
        public Builder executionContext(String var1);

        public Builder scheduledEventId(Long var1);

        public Builder startedEventId(Long var1);
    }
}

