/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.transform.ContinueAsNewWorkflowExecutionDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContinueAsNewWorkflowExecutionDecisionAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, ContinueAsNewWorkflowExecutionDecisionAttributes> {
    private final String input;
    private final String executionStartToCloseTimeout;
    private final TaskList taskList;
    private final String taskPriority;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final List<String> tagList;
    private final String workflowTypeVersion;
    private final String lambdaRole;

    private ContinueAsNewWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.tagList = builder.tagList;
        this.workflowTypeVersion = builder.workflowTypeVersion;
        this.lambdaRole = builder.lambdaRole;
    }

    public String input() {
        return this.input;
    }

    public String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public TaskList taskList() {
        return this.taskList;
    }

    public String taskPriority() {
        return this.taskPriority;
    }

    public String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public String childPolicy() {
        return this.childPolicy;
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public String workflowTypeVersion() {
        return this.workflowTypeVersion;
    }

    public String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.input() == null ? 0 : this.input().hashCode());
        hashCode = 31 * hashCode + (this.executionStartToCloseTimeout() == null ? 0 : this.executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + (this.taskList() == null ? 0 : this.taskList().hashCode());
        hashCode = 31 * hashCode + (this.taskPriority() == null ? 0 : this.taskPriority().hashCode());
        hashCode = 31 * hashCode + (this.taskStartToCloseTimeout() == null ? 0 : this.taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + (this.childPolicy() == null ? 0 : this.childPolicy().hashCode());
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        hashCode = 31 * hashCode + (this.workflowTypeVersion() == null ? 0 : this.workflowTypeVersion().hashCode());
        hashCode = 31 * hashCode + (this.lambdaRole() == null ? 0 : this.lambdaRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueAsNewWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        ContinueAsNewWorkflowExecutionDecisionAttributes other = (ContinueAsNewWorkflowExecutionDecisionAttributes)obj;
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.workflowTypeVersion() == null ^ this.workflowTypeVersion() == null) {
            return false;
        }
        if (other.workflowTypeVersion() != null && !other.workflowTypeVersion().equals(this.workflowTypeVersion())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        return other.lambdaRole() == null || other.lambdaRole().equals(this.lambdaRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.input() != null) {
            sb.append("Input: ").append(this.input()).append(",");
        }
        if (this.executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(this.executionStartToCloseTimeout()).append(",");
        }
        if (this.taskList() != null) {
            sb.append("TaskList: ").append(this.taskList()).append(",");
        }
        if (this.taskPriority() != null) {
            sb.append("TaskPriority: ").append(this.taskPriority()).append(",");
        }
        if (this.taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(this.taskStartToCloseTimeout()).append(",");
        }
        if (this.childPolicy() != null) {
            sb.append("ChildPolicy: ").append(this.childPolicy()).append(",");
        }
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        if (this.workflowTypeVersion() != null) {
            sb.append("WorkflowTypeVersion: ").append(this.workflowTypeVersion()).append(",");
        }
        if (this.lambdaRole() != null) {
            sb.append("LambdaRole: ").append(this.lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContinueAsNewWorkflowExecutionDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String input;
        private String executionStartToCloseTimeout;
        private TaskList taskList;
        private String taskPriority;
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private List<String> tagList;
        private String workflowTypeVersion;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueAsNewWorkflowExecutionDecisionAttributes model) {
            this.setInput(model.input);
            this.setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.setTaskList(model.taskList);
            this.setTaskPriority(model.taskPriority);
            this.setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.setChildPolicy(model.childPolicy);
            this.setTagList(model.tagList);
            this.setWorkflowTypeVersion(model.workflowTypeVersion);
            this.setLambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList getTaskList() {
            return this.taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final String getWorkflowTypeVersion() {
            return this.workflowTypeVersion;
        }

        @Override
        public final Builder workflowTypeVersion(String workflowTypeVersion) {
            this.workflowTypeVersion = workflowTypeVersion;
            return this;
        }

        public final void setWorkflowTypeVersion(String workflowTypeVersion) {
            this.workflowTypeVersion = workflowTypeVersion;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        public ContinueAsNewWorkflowExecutionDecisionAttributes build() {
            return new ContinueAsNewWorkflowExecutionDecisionAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContinueAsNewWorkflowExecutionDecisionAttributes> {
        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskList(TaskList var1);

        public Builder taskPriority(String var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder workflowTypeVersion(String var1);

        public Builder lambdaRole(String var1);
    }
}

