/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * WorkflowExecutionInfo JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class WorkflowExecutionInfoUnmarshaller implements Unmarshaller<WorkflowExecutionInfo, JsonUnmarshallerContext> {

    public WorkflowExecutionInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        WorkflowExecutionInfo.Builder workflowExecutionInfoBuilder = WorkflowExecutionInfo.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("execution", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.execution(WorkflowExecutionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowType", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.workflowType(WorkflowTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("startTimestamp", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder
                            .startTimestamp(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("closeTimestamp", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder
                            .closeTimestamp(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("executionStatus", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.executionStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("closeStatus", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.closeStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("parent", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.parent(WorkflowExecutionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("tagList", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.tagList(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("cancelRequested", targetDepth)) {
                    context.nextToken();
                    workflowExecutionInfoBuilder.cancelRequested(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return workflowExecutionInfoBuilder.build();
    }

    private static WorkflowExecutionInfoUnmarshaller INSTANCE;

    public static WorkflowExecutionInfoUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new WorkflowExecutionInfoUnmarshaller();
        return INSTANCE;
    }
}