/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.swf.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * WorkflowExecutionInfoMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class WorkflowExecutionInfoMarshaller {

    private static final MarshallingInfo<StructuredPojo> EXECUTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("execution").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWTYPE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workflowType")
            .build();
    private static final MarshallingInfo<java.util.Date> STARTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimestamp").build();
    private static final MarshallingInfo<java.util.Date> CLOSETIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("closeTimestamp").build();
    private static final MarshallingInfo<String> EXECUTIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStatus").build();
    private static final MarshallingInfo<String> CLOSESTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("closeStatus").build();
    private static final MarshallingInfo<StructuredPojo> PARENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parent").build();
    private static final MarshallingInfo<List> TAGLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tagList").build();
    private static final MarshallingInfo<Boolean> CANCELREQUESTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cancelRequested").build();

    private static final WorkflowExecutionInfoMarshaller instance = new WorkflowExecutionInfoMarshaller();

    public static WorkflowExecutionInfoMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(WorkflowExecutionInfo workflowExecutionInfo, ProtocolMarshaller protocolMarshaller) {

        if (workflowExecutionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(workflowExecutionInfo.execution(), EXECUTION_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.workflowType(), WORKFLOWTYPE_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.startTimestamp(), STARTTIMESTAMP_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.closeTimestamp(), CLOSETIMESTAMP_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.executionStatus(), EXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.closeStatus(), CLOSESTATUS_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.parent(), PARENT_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.tagList(), TAGLIST_BINDING);
            protocolMarshaller.marshall(workflowExecutionInfo.cancelRequested(), CANCELREQUESTED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
