/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PollForActivityTaskResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PollForActivityTaskResponseUnmarshaller implements
        Unmarshaller<PollForActivityTaskResponse, JsonUnmarshallerContext> {

    public PollForActivityTaskResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        PollForActivityTaskResponse.Builder pollForActivityTaskResponseBuilder = PollForActivityTaskResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return pollForActivityTaskResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("taskToken", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.taskToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("activityId", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.activityId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("startedEventId", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.startedEventId(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("workflowExecution", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.workflowExecution(WorkflowExecutionUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("activityType", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.activityType(ActivityTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("input", targetDepth)) {
                    context.nextToken();
                    pollForActivityTaskResponseBuilder.input(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return pollForActivityTaskResponseBuilder.build();
    }

    private static PollForActivityTaskResponseUnmarshaller INSTANCE;

    public static PollForActivityTaskResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new PollForActivityTaskResponseUnmarshaller();
        return INSTANCE;
    }
}