/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * HistoryEvent JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HistoryEventUnmarshaller implements Unmarshaller<HistoryEvent, JsonUnmarshallerContext> {

    public HistoryEvent unmarshall(JsonUnmarshallerContext context) throws Exception {
        HistoryEvent.Builder historyEventBuilder = HistoryEvent.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("eventTimestamp", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.eventTimestamp(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("eventType", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.eventType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("eventId", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.eventId(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("workflowExecutionStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionStartedEventAttributes(WorkflowExecutionStartedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionCompletedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionCompletedEventAttributes(WorkflowExecutionCompletedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("completeWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .completeWorkflowExecutionFailedEventAttributes(CompleteWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.workflowExecutionFailedEventAttributes(WorkflowExecutionFailedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("failWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .failWorkflowExecutionFailedEventAttributes(FailWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionTimedOutEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionTimedOutEventAttributes(WorkflowExecutionTimedOutEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionCanceledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionCanceledEventAttributes(WorkflowExecutionCanceledEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("cancelWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .cancelWorkflowExecutionFailedEventAttributes(CancelWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionContinuedAsNewEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionContinuedAsNewEventAttributes(WorkflowExecutionContinuedAsNewEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("continueAsNewWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .continueAsNewWorkflowExecutionFailedEventAttributes(ContinueAsNewWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionTerminatedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionTerminatedEventAttributes(WorkflowExecutionTerminatedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionCancelRequestedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionCancelRequestedEventAttributes(WorkflowExecutionCancelRequestedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("decisionTaskScheduledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("decisionTaskStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("decisionTaskCompletedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("decisionTaskTimedOutEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskScheduledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskCompletedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskTimedOutEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskCanceledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("activityTaskCancelRequestedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .activityTaskCancelRequestedEventAttributes(ActivityTaskCancelRequestedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("workflowExecutionSignaledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .workflowExecutionSignaledEventAttributes(WorkflowExecutionSignaledEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("markerRecordedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.markerRecordedEventAttributes(MarkerRecordedEventAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("recordMarkerFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("timerStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.timerStartedEventAttributes(TimerStartedEventAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("timerFiredEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.timerFiredEventAttributes(TimerFiredEventAttributesUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("timerCanceledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.timerCanceledEventAttributes(TimerCanceledEventAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("startChildWorkflowExecutionInitiatedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .startChildWorkflowExecutionInitiatedEventAttributes(StartChildWorkflowExecutionInitiatedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionStartedEventAttributes(ChildWorkflowExecutionStartedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionCompletedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionCompletedEventAttributes(ChildWorkflowExecutionCompletedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionFailedEventAttributes(ChildWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionTimedOutEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionTimedOutEventAttributes(ChildWorkflowExecutionTimedOutEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionCanceledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionCanceledEventAttributes(ChildWorkflowExecutionCanceledEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("childWorkflowExecutionTerminatedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .childWorkflowExecutionTerminatedEventAttributes(ChildWorkflowExecutionTerminatedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("signalExternalWorkflowExecutionInitiatedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .signalExternalWorkflowExecutionInitiatedEventAttributes(SignalExternalWorkflowExecutionInitiatedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("externalWorkflowExecutionSignaledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .externalWorkflowExecutionSignaledEventAttributes(ExternalWorkflowExecutionSignaledEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("signalExternalWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .signalExternalWorkflowExecutionFailedEventAttributes(SignalExternalWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("externalWorkflowExecutionCancelRequestedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .externalWorkflowExecutionCancelRequestedEventAttributes(ExternalWorkflowExecutionCancelRequestedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestCancelExternalWorkflowExecutionInitiatedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .requestCancelExternalWorkflowExecutionInitiatedEventAttributes(RequestCancelExternalWorkflowExecutionInitiatedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestCancelExternalWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .requestCancelExternalWorkflowExecutionFailedEventAttributes(RequestCancelExternalWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("scheduleActivityTaskFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .scheduleActivityTaskFailedEventAttributes(ScheduleActivityTaskFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestCancelActivityTaskFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .requestCancelActivityTaskFailedEventAttributes(RequestCancelActivityTaskFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("startTimerFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.startTimerFailedEventAttributes(StartTimerFailedEventAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("cancelTimerFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("startChildWorkflowExecutionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .startChildWorkflowExecutionFailedEventAttributes(StartChildWorkflowExecutionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("lambdaFunctionScheduledEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.lambdaFunctionScheduledEventAttributes(LambdaFunctionScheduledEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("lambdaFunctionStartedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("lambdaFunctionCompletedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.lambdaFunctionCompletedEventAttributes(LambdaFunctionCompletedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("lambdaFunctionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("lambdaFunctionTimedOutEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder.lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("scheduleLambdaFunctionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .scheduleLambdaFunctionFailedEventAttributes(ScheduleLambdaFunctionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("startLambdaFunctionFailedEventAttributes", targetDepth)) {
                    context.nextToken();
                    historyEventBuilder
                            .startLambdaFunctionFailedEventAttributes(StartLambdaFunctionFailedEventAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return historyEventBuilder.build();
    }

    private static HistoryEventUnmarshaller INSTANCE;

    public static HistoryEventUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new HistoryEventUnmarshaller();
        return INSTANCE;
    }
}