/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.swf.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * HistoryEventMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class HistoryEventMarshaller {

    private static final MarshallingInfo<java.util.Date> EVENTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTimestamp").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<Long> EVENTID_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> COMPLETEWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("completeWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> FAILWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("failWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CANCELWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cancelWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCONTINUEDASNEWEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionContinuedAsNewEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CONTINUEASNEWWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("continueAsNewWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionTerminatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("decisionTaskScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("decisionTaskStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("decisionTaskCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> DECISIONTASKTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("decisionTaskTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTASKCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("activityTaskCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> WORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("workflowExecutionSignaledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> MARKERRECORDEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("markerRecordedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> RECORDMARKERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("recordMarkerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("timerStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERFIREDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("timerFiredEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> TIMERCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("timerCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTCHILDWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startChildWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionCanceledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CHILDWORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("childWorkflowExecutionTerminatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SIGNALEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("signalExternalWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> EXTERNALWORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("externalWorkflowExecutionSignaledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SIGNALEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("signalExternalWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> EXTERNALWORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("externalWorkflowExecutionCancelRequestedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("requestCancelExternalWorkflowExecutionInitiatedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("requestCancelExternalWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULEACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("scheduleActivityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTCANCELACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("requestCancelActivityTaskFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTTIMERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startTimerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> CANCELTIMERFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cancelTimerFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTCHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startChildWorkflowExecutionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lambdaFunctionScheduledEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSTARTEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lambdaFunctionStartedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONCOMPLETEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lambdaFunctionCompletedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lambdaFunctionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONTIMEDOUTEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lambdaFunctionTimedOutEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULELAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("scheduleLambdaFunctionFailedEventAttributes").build();
    private static final MarshallingInfo<StructuredPojo> STARTLAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startLambdaFunctionFailedEventAttributes").build();

    private static final HistoryEventMarshaller instance = new HistoryEventMarshaller();

    public static HistoryEventMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(HistoryEvent historyEvent, ProtocolMarshaller protocolMarshaller) {

        if (historyEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(historyEvent.eventTimestamp(), EVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall(historyEvent.eventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall(historyEvent.eventId(), EVENTID_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionStartedEventAttributes(),
                    WORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionCompletedEventAttributes(),
                    WORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.completeWorkflowExecutionFailedEventAttributes(),
                    COMPLETEWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionFailedEventAttributes(),
                    WORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.failWorkflowExecutionFailedEventAttributes(),
                    FAILWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionTimedOutEventAttributes(),
                    WORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionCanceledEventAttributes(),
                    WORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.cancelWorkflowExecutionFailedEventAttributes(),
                    CANCELWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionContinuedAsNewEventAttributes(),
                    WORKFLOWEXECUTIONCONTINUEDASNEWEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.continueAsNewWorkflowExecutionFailedEventAttributes(),
                    CONTINUEASNEWWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionTerminatedEventAttributes(),
                    WORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionCancelRequestedEventAttributes(),
                    WORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.decisionTaskScheduledEventAttributes(),
                    DECISIONTASKSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.decisionTaskStartedEventAttributes(),
                    DECISIONTASKSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.decisionTaskCompletedEventAttributes(),
                    DECISIONTASKCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.decisionTaskTimedOutEventAttributes(),
                    DECISIONTASKTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskScheduledEventAttributes(),
                    ACTIVITYTASKSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskStartedEventAttributes(),
                    ACTIVITYTASKSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskCompletedEventAttributes(),
                    ACTIVITYTASKCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskFailedEventAttributes(),
                    ACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskTimedOutEventAttributes(),
                    ACTIVITYTASKTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskCanceledEventAttributes(),
                    ACTIVITYTASKCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.activityTaskCancelRequestedEventAttributes(),
                    ACTIVITYTASKCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.workflowExecutionSignaledEventAttributes(),
                    WORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.markerRecordedEventAttributes(), MARKERRECORDEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.recordMarkerFailedEventAttributes(),
                    RECORDMARKERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.timerStartedEventAttributes(), TIMERSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.timerFiredEventAttributes(), TIMERFIREDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.timerCanceledEventAttributes(), TIMERCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.startChildWorkflowExecutionInitiatedEventAttributes(),
                    STARTCHILDWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionStartedEventAttributes(),
                    CHILDWORKFLOWEXECUTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionCompletedEventAttributes(),
                    CHILDWORKFLOWEXECUTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionFailedEventAttributes(),
                    CHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionTimedOutEventAttributes(),
                    CHILDWORKFLOWEXECUTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionCanceledEventAttributes(),
                    CHILDWORKFLOWEXECUTIONCANCELEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.childWorkflowExecutionTerminatedEventAttributes(),
                    CHILDWORKFLOWEXECUTIONTERMINATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.signalExternalWorkflowExecutionInitiatedEventAttributes(),
                    SIGNALEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.externalWorkflowExecutionSignaledEventAttributes(),
                    EXTERNALWORKFLOWEXECUTIONSIGNALEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.signalExternalWorkflowExecutionFailedEventAttributes(),
                    SIGNALEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.externalWorkflowExecutionCancelRequestedEventAttributes(),
                    EXTERNALWORKFLOWEXECUTIONCANCELREQUESTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.requestCancelExternalWorkflowExecutionInitiatedEventAttributes(),
                    REQUESTCANCELEXTERNALWORKFLOWEXECUTIONINITIATEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.requestCancelExternalWorkflowExecutionFailedEventAttributes(),
                    REQUESTCANCELEXTERNALWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.scheduleActivityTaskFailedEventAttributes(),
                    SCHEDULEACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.requestCancelActivityTaskFailedEventAttributes(),
                    REQUESTCANCELACTIVITYTASKFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.startTimerFailedEventAttributes(), STARTTIMERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller
                    .marshall(historyEvent.cancelTimerFailedEventAttributes(), CANCELTIMERFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.startChildWorkflowExecutionFailedEventAttributes(),
                    STARTCHILDWORKFLOWEXECUTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.lambdaFunctionScheduledEventAttributes(),
                    LAMBDAFUNCTIONSCHEDULEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.lambdaFunctionStartedEventAttributes(),
                    LAMBDAFUNCTIONSTARTEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.lambdaFunctionCompletedEventAttributes(),
                    LAMBDAFUNCTIONCOMPLETEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.lambdaFunctionFailedEventAttributes(),
                    LAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.lambdaFunctionTimedOutEventAttributes(),
                    LAMBDAFUNCTIONTIMEDOUTEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.scheduleLambdaFunctionFailedEventAttributes(),
                    SCHEDULELAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(historyEvent.startLambdaFunctionFailedEventAttributes(),
                    STARTLAMBDAFUNCTIONFAILEDEVENTATTRIBUTES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
