/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Decision JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DecisionUnmarshaller implements Unmarshaller<Decision, JsonUnmarshallerContext> {

    public Decision unmarshall(JsonUnmarshallerContext context) throws Exception {
        Decision.Builder decisionBuilder = Decision.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("decisionType", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.decisionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("scheduleActivityTaskDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.scheduleActivityTaskDecisionAttributes(ScheduleActivityTaskDecisionAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestCancelActivityTaskDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .requestCancelActivityTaskDecisionAttributes(RequestCancelActivityTaskDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("completeWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .completeWorkflowExecutionDecisionAttributes(CompleteWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("failWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.failWorkflowExecutionDecisionAttributes(FailWorkflowExecutionDecisionAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("cancelWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .cancelWorkflowExecutionDecisionAttributes(CancelWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("continueAsNewWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .continueAsNewWorkflowExecutionDecisionAttributes(ContinueAsNewWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("recordMarkerDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.recordMarkerDecisionAttributes(RecordMarkerDecisionAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("startTimerDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.startTimerDecisionAttributes(StartTimerDecisionAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("cancelTimerDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.cancelTimerDecisionAttributes(CancelTimerDecisionAttributesUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("signalExternalWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .signalExternalWorkflowExecutionDecisionAttributes(SignalExternalWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("requestCancelExternalWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .requestCancelExternalWorkflowExecutionDecisionAttributes(RequestCancelExternalWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("startChildWorkflowExecutionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder
                            .startChildWorkflowExecutionDecisionAttributes(StartChildWorkflowExecutionDecisionAttributesUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("scheduleLambdaFunctionDecisionAttributes", targetDepth)) {
                    context.nextToken();
                    decisionBuilder.scheduleLambdaFunctionDecisionAttributes(ScheduleLambdaFunctionDecisionAttributesUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return decisionBuilder.build();
    }

    private static DecisionUnmarshaller INSTANCE;

    public static DecisionUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DecisionUnmarshaller();
        return INSTANCE;
    }
}