/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ActivityTypeConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ActivityTypeConfigurationUnmarshaller implements Unmarshaller<ActivityTypeConfiguration, JsonUnmarshallerContext> {

    public ActivityTypeConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ActivityTypeConfiguration.Builder activityTypeConfigurationBuilder = ActivityTypeConfiguration.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("defaultTaskStartToCloseTimeout", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskStartToCloseTimeout(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("defaultTaskHeartbeatTimeout", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskHeartbeatTimeout(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("defaultTaskList", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskList(TaskListUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("defaultTaskPriority", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskPriority(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("defaultTaskScheduleToStartTimeout", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskScheduleToStartTimeout(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("defaultTaskScheduleToCloseTimeout", targetDepth)) {
                    context.nextToken();
                    activityTypeConfigurationBuilder.defaultTaskScheduleToCloseTimeout(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return activityTypeConfigurationBuilder.build();
    }

    private static ActivityTypeConfigurationUnmarshaller INSTANCE;

    public static ActivityTypeConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ActivityTypeConfigurationUnmarshaller();
        return INSTANCE;
    }
}