/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowType implements StructuredPojo, ToCopyableBuilder<WorkflowType.Builder, WorkflowType> {
    private final String name;

    private final String version;

    private WorkflowType(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    /**
     * <p>
     * <b>Required.</b> The name of the workflow type.
     * </p>
     * <note>The combination of workflow type name and version must be unique with in a domain.</note>
     * 
     * @return Required.</b> The name of the workflow type.</p>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * <b>Required.</b> The version of the workflow type.
     * </p>
     * <note>The combination of workflow type name and version must be unique with in a domain.</note>
     * 
     * @return Required.</b> The version of the workflow type.</p>
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowType)) {
            return false;
        }
        WorkflowType other = (WorkflowType) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowType> {
        /**
         * <p>
         * <b>Required.</b> The name of the workflow type.
         * </p>
         * <note>The combination of workflow type name and version must be unique with in a domain.</note>
         * 
         * @param name
         *        Required.</b> The name of the workflow type.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * <b>Required.</b> The version of the workflow type.
         * </p>
         * <note>The combination of workflow type name and version must be unique with in a domain.</note>
         * 
         * @param version
         *        Required.</b> The version of the workflow type.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowType model) {
            setName(model.name);
            setVersion(model.version);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public WorkflowType build() {
            return new WorkflowType(this);
        }
    }
}
