/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionTerminatedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>WorkflowExecutionTerminated</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionTerminatedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionTerminatedEventAttributes.Builder, WorkflowExecutionTerminatedEventAttributes> {
    private final String reason;

    private final String details;

    private final String childPolicy;

    private final String cause;

    private WorkflowExecutionTerminatedEventAttributes(BuilderImpl builder) {
        this.reason = builder.reason;
        this.details = builder.details;
        this.childPolicy = builder.childPolicy;
        this.cause = builder.cause;
    }

    /**
     * <p>
     * The reason provided for the termination (if any).
     * </p>
     * 
     * @return The reason provided for the termination (if any).
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * The details provided for the termination (if any).
     * </p>
     * 
     * @return The details provided for the termination (if any).
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * The policy used for the child workflow executions of this workflow execution.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return The policy used for the child workflow executions of this workflow execution.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    /**
     * <p>
     * If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This happens
     * if the parent workflow execution times out or is terminated and the child policy is set to terminate child
     * executions.
     * </p>
     * 
     * @return If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This
     *         happens if the parent workflow execution times out or is terminated and the child policy is set to
     *         terminate child executions.
     * @see WorkflowExecutionTerminatedCause
     */
    public String cause() {
        return cause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        hashCode = 31 * hashCode + ((cause() == null) ? 0 : cause().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionTerminatedEventAttributes)) {
            return false;
        }
        WorkflowExecutionTerminatedEventAttributes other = (WorkflowExecutionTerminatedEventAttributes) obj;
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        if (cause() != null) {
            sb.append("Cause: ").append(cause()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionTerminatedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionTerminatedEventAttributes> {
        /**
         * <p>
         * The reason provided for the termination (if any).
         * </p>
         * 
         * @param reason
         *        The reason provided for the termination (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The details provided for the termination (if any).
         * </p>
         * 
         * @param details
         *        The details provided for the termination (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This
         * happens if the parent workflow execution times out or is terminated and the child policy is set to terminate
         * child executions.
         * </p>
         * 
         * @param cause
         *        If set, indicates that the workflow execution was automatically terminated, and specifies the cause.
         *        This happens if the parent workflow execution times out or is terminated and the child policy is set
         *        to terminate child executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTerminatedCause
         */
        Builder cause(String cause);

        /**
         * <p>
         * If set, indicates that the workflow execution was automatically terminated, and specifies the cause. This
         * happens if the parent workflow execution times out or is terminated and the child policy is set to terminate
         * child executions.
         * </p>
         * 
         * @param cause
         *        If set, indicates that the workflow execution was automatically terminated, and specifies the cause.
         *        This happens if the parent workflow execution times out or is terminated and the child policy is set
         *        to terminate child executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTerminatedCause
         */
        Builder cause(WorkflowExecutionTerminatedCause cause);
    }

    private static final class BuilderImpl implements Builder {
        private String reason;

        private String details;

        private String childPolicy;

        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionTerminatedEventAttributes model) {
            setReason(model.reason);
            setDetails(model.details);
            setChildPolicy(model.childPolicy);
            setCause(model.cause);
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(WorkflowExecutionTerminatedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final void setCause(WorkflowExecutionTerminatedCause cause) {
            this.cause(cause.toString());
        }

        @Override
        public WorkflowExecutionTerminatedEventAttributes build() {
            return new WorkflowExecutionTerminatedEventAttributes(this);
        }
    }
}
