/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionStartedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of <code>WorkflowExecutionStarted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionStartedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionStartedEventAttributes.Builder, WorkflowExecutionStartedEventAttributes> {
    private final String input;

    private final String executionStartToCloseTimeout;

    private final String taskStartToCloseTimeout;

    private final String childPolicy;

    private final TaskList taskList;

    private final WorkflowType workflowType;

    private final List<String> tagList;

    private final String taskPriority;

    private final String continuedExecutionRunId;

    private final WorkflowExecution parentWorkflowExecution;

    private final Long parentInitiatedEventId;

    private final String lambdaRole;

    private WorkflowExecutionStartedEventAttributes(BuilderImpl builder) {
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.taskList = builder.taskList;
        this.workflowType = builder.workflowType;
        this.tagList = builder.tagList;
        this.taskPriority = builder.taskPriority;
        this.continuedExecutionRunId = builder.continuedExecutionRunId;
        this.parentWorkflowExecution = builder.parentWorkflowExecution;
        this.parentInitiatedEventId = builder.parentInitiatedEventId;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The input provided to the workflow execution (if any).
     * </p>
     * 
     * @return The input provided to the workflow execution (if any).
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum duration for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The maximum duration of decision tasks for this workflow type.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration of decision tasks for this workflow type.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    /**
     * <p>
     * The name of the task list for scheduling the decision tasks for this workflow execution.
     * </p>
     * 
     * @return The name of the task list for scheduling the decision tasks for this workflow execution.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The workflow type of this execution.
     * </p>
     * 
     * @return The workflow type of this execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
     * </p>
     * 
     * @return The list of tags associated with this workflow execution. An execution can have up to 5 tags.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     *
     * @return
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
     * contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
     * execution.
     * </p>
     * 
     * @return If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision,
     *         then it contains the <code>runId</code> of the previous workflow execution that was closed and continued
     *         as this execution.
     */
    public String continuedExecutionRunId() {
        return continuedExecutionRunId;
    }

    /**
     * <p>
     * The source workflow execution that started this workflow execution. The member is not set if the workflow
     * execution was not started by a workflow.
     * </p>
     * 
     * @return The source workflow execution that started this workflow execution. The member is not set if the workflow
     *         execution was not started by a workflow.
     */
    public WorkflowExecution parentWorkflowExecution() {
        return parentWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     * <code>StartChildWorkflowExecution</code> decision to start this workflow execution. The source event with this ID
     * can be found in the history of the source workflow execution. This information can be useful for diagnosing
     * problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>StartChildWorkflowExecution</code> decision to start this workflow execution. The source event with
     *         this ID can be found in the history of the source workflow execution. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long parentInitiatedEventId() {
        return parentInitiatedEventId;
    }

    /**
     * <p>
     * The IAM role attached to this workflow execution to use when invoking AWS Lambda functions.
     * </p>
     * 
     * @return The IAM role attached to this workflow execution to use when invoking AWS Lambda functions.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((executionStartToCloseTimeout() == null) ? 0 : executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((taskStartToCloseTimeout() == null) ? 0 : taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((tagList() == null) ? 0 : tagList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((continuedExecutionRunId() == null) ? 0 : continuedExecutionRunId().hashCode());
        hashCode = 31 * hashCode + ((parentWorkflowExecution() == null) ? 0 : parentWorkflowExecution().hashCode());
        hashCode = 31 * hashCode + ((parentInitiatedEventId() == null) ? 0 : parentInitiatedEventId().hashCode());
        hashCode = 31 * hashCode + ((lambdaRole() == null) ? 0 : lambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionStartedEventAttributes)) {
            return false;
        }
        WorkflowExecutionStartedEventAttributes other = (WorkflowExecutionStartedEventAttributes) obj;
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null
                && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.continuedExecutionRunId() == null ^ this.continuedExecutionRunId() == null) {
            return false;
        }
        if (other.continuedExecutionRunId() != null && !other.continuedExecutionRunId().equals(this.continuedExecutionRunId())) {
            return false;
        }
        if (other.parentWorkflowExecution() == null ^ this.parentWorkflowExecution() == null) {
            return false;
        }
        if (other.parentWorkflowExecution() != null && !other.parentWorkflowExecution().equals(this.parentWorkflowExecution())) {
            return false;
        }
        if (other.parentInitiatedEventId() == null ^ this.parentInitiatedEventId() == null) {
            return false;
        }
        if (other.parentInitiatedEventId() != null && !other.parentInitiatedEventId().equals(this.parentInitiatedEventId())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        if (other.lambdaRole() != null && !other.lambdaRole().equals(this.lambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(executionStartToCloseTimeout()).append(",");
        }
        if (taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(taskStartToCloseTimeout()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (tagList() != null) {
            sb.append("TagList: ").append(tagList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (continuedExecutionRunId() != null) {
            sb.append("ContinuedExecutionRunId: ").append(continuedExecutionRunId()).append(",");
        }
        if (parentWorkflowExecution() != null) {
            sb.append("ParentWorkflowExecution: ").append(parentWorkflowExecution()).append(",");
        }
        if (parentInitiatedEventId() != null) {
            sb.append("ParentInitiatedEventId: ").append(parentInitiatedEventId()).append(",");
        }
        if (lambdaRole() != null) {
            sb.append("LambdaRole: ").append(lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionStartedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionStartedEventAttributes> {
        /**
         * <p>
         * The input provided to the workflow execution (if any).
         * </p>
         * 
         * @param input
         *        The input provided to the workflow execution (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum duration for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param executionStartToCloseTimeout
         *        The maximum duration for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The maximum duration of decision tasks for this workflow type.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param taskStartToCloseTimeout
         *        The maximum duration of decision tasks for this workflow type.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The name of the task list for scheduling the decision tasks for this workflow execution.
         * </p>
         * 
         * @param taskList
         *        The name of the task list for scheduling the decision tasks for this workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The workflow type of this execution.
         * </p>
         * 
         * @param workflowType
         *        The workflow type of this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagList(java.util.Collection)} or {@link #withTagList(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with this workflow execution. An execution can have up to 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         *
         * @param taskPriority
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision, then it
         * contains the <code>runId</code> of the previous workflow execution that was closed and continued as this
         * execution.
         * </p>
         * 
         * @param continuedExecutionRunId
         *        If this workflow execution was started due to a <code>ContinueAsNewWorkflowExecution</code> decision,
         *        then it contains the <code>runId</code> of the previous workflow execution that was closed and
         *        continued as this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuedExecutionRunId(String continuedExecutionRunId);

        /**
         * <p>
         * The source workflow execution that started this workflow execution. The member is not set if the workflow
         * execution was not started by a workflow.
         * </p>
         * 
         * @param parentWorkflowExecution
         *        The source workflow execution that started this workflow execution. The member is not set if the
         *        workflow execution was not started by a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution);

        /**
         * <p>
         * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         * <code>StartChildWorkflowExecution</code> decision to start this workflow execution. The source event with
         * this ID can be found in the history of the source workflow execution. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param parentInitiatedEventId
         *        The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>StartChildWorkflowExecution</code> decision to start this workflow execution. The source event
         *        with this ID can be found in the history of the source workflow execution. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentInitiatedEventId(Long parentInitiatedEventId);

        /**
         * <p>
         * The IAM role attached to this workflow execution to use when invoking AWS Lambda functions.
         * </p>
         * 
         * @param lambdaRole
         *        The IAM role attached to this workflow execution to use when invoking AWS Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private String input;

        private String executionStartToCloseTimeout;

        private String taskStartToCloseTimeout;

        private String childPolicy;

        private TaskList taskList;

        private WorkflowType workflowType;

        private List<String> tagList;

        private String taskPriority;

        private String continuedExecutionRunId;

        private WorkflowExecution parentWorkflowExecution;

        private Long parentInitiatedEventId;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionStartedEventAttributes model) {
            setInput(model.input);
            setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            setChildPolicy(model.childPolicy);
            setTaskList(model.taskList);
            setWorkflowType(model.workflowType);
            setTagList(model.tagList);
            setTaskPriority(model.taskPriority);
            setContinuedExecutionRunId(model.continuedExecutionRunId);
            setParentWorkflowExecution(model.parentWorkflowExecution);
            setParentInitiatedEventId(model.parentInitiatedEventId);
            setLambdaRole(model.lambdaRole);
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getContinuedExecutionRunId() {
            return continuedExecutionRunId;
        }

        @Override
        public final Builder continuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
            return this;
        }

        public final void setContinuedExecutionRunId(String continuedExecutionRunId) {
            this.continuedExecutionRunId = continuedExecutionRunId;
        }

        public final WorkflowExecution getParentWorkflowExecution() {
            return parentWorkflowExecution;
        }

        @Override
        public final Builder parentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
            return this;
        }

        public final void setParentWorkflowExecution(WorkflowExecution parentWorkflowExecution) {
            this.parentWorkflowExecution = parentWorkflowExecution;
        }

        public final Long getParentInitiatedEventId() {
            return parentInitiatedEventId;
        }

        @Override
        public final Builder parentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
            return this;
        }

        public final void setParentInitiatedEventId(Long parentInitiatedEventId) {
            this.parentInitiatedEventId = parentInitiatedEventId;
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public WorkflowExecutionStartedEventAttributes build() {
            return new WorkflowExecutionStartedEventAttributes(this);
        }
    }
}
