/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionOpenCountsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the counts of open tasks, child workflow executions and timers for a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionOpenCounts implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionOpenCounts.Builder, WorkflowExecutionOpenCounts> {
    private final Integer openActivityTasks;

    private final Integer openDecisionTasks;

    private final Integer openTimers;

    private final Integer openChildWorkflowExecutions;

    private final Integer openLambdaFunctions;

    private WorkflowExecutionOpenCounts(BuilderImpl builder) {
        this.openActivityTasks = builder.openActivityTasks;
        this.openDecisionTasks = builder.openDecisionTasks;
        this.openTimers = builder.openTimers;
        this.openChildWorkflowExecutions = builder.openChildWorkflowExecutions;
        this.openLambdaFunctions = builder.openLambdaFunctions;
    }

    /**
     * <p>
     * The count of activity tasks whose status is OPEN.
     * </p>
     * 
     * @return The count of activity tasks whose status is OPEN.
     */
    public Integer openActivityTasks() {
        return openActivityTasks;
    }

    /**
     * <p>
     * The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision task.
     * </p>
     * 
     * @return The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision
     *         task.
     */
    public Integer openDecisionTasks() {
        return openDecisionTasks;
    }

    /**
     * <p>
     * The count of timers started by this workflow execution that have not fired yet.
     * </p>
     * 
     * @return The count of timers started by this workflow execution that have not fired yet.
     */
    public Integer openTimers() {
        return openTimers;
    }

    /**
     * <p>
     * The count of child workflow executions whose status is OPEN.
     * </p>
     * 
     * @return The count of child workflow executions whose status is OPEN.
     */
    public Integer openChildWorkflowExecutions() {
        return openChildWorkflowExecutions;
    }

    /**
     * <p>
     * The count of AWS Lambda functions that are currently executing.
     * </p>
     * 
     * @return The count of AWS Lambda functions that are currently executing.
     */
    public Integer openLambdaFunctions() {
        return openLambdaFunctions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((openActivityTasks() == null) ? 0 : openActivityTasks().hashCode());
        hashCode = 31 * hashCode + ((openDecisionTasks() == null) ? 0 : openDecisionTasks().hashCode());
        hashCode = 31 * hashCode + ((openTimers() == null) ? 0 : openTimers().hashCode());
        hashCode = 31 * hashCode + ((openChildWorkflowExecutions() == null) ? 0 : openChildWorkflowExecutions().hashCode());
        hashCode = 31 * hashCode + ((openLambdaFunctions() == null) ? 0 : openLambdaFunctions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionOpenCounts)) {
            return false;
        }
        WorkflowExecutionOpenCounts other = (WorkflowExecutionOpenCounts) obj;
        if (other.openActivityTasks() == null ^ this.openActivityTasks() == null) {
            return false;
        }
        if (other.openActivityTasks() != null && !other.openActivityTasks().equals(this.openActivityTasks())) {
            return false;
        }
        if (other.openDecisionTasks() == null ^ this.openDecisionTasks() == null) {
            return false;
        }
        if (other.openDecisionTasks() != null && !other.openDecisionTasks().equals(this.openDecisionTasks())) {
            return false;
        }
        if (other.openTimers() == null ^ this.openTimers() == null) {
            return false;
        }
        if (other.openTimers() != null && !other.openTimers().equals(this.openTimers())) {
            return false;
        }
        if (other.openChildWorkflowExecutions() == null ^ this.openChildWorkflowExecutions() == null) {
            return false;
        }
        if (other.openChildWorkflowExecutions() != null
                && !other.openChildWorkflowExecutions().equals(this.openChildWorkflowExecutions())) {
            return false;
        }
        if (other.openLambdaFunctions() == null ^ this.openLambdaFunctions() == null) {
            return false;
        }
        if (other.openLambdaFunctions() != null && !other.openLambdaFunctions().equals(this.openLambdaFunctions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (openActivityTasks() != null) {
            sb.append("OpenActivityTasks: ").append(openActivityTasks()).append(",");
        }
        if (openDecisionTasks() != null) {
            sb.append("OpenDecisionTasks: ").append(openDecisionTasks()).append(",");
        }
        if (openTimers() != null) {
            sb.append("OpenTimers: ").append(openTimers()).append(",");
        }
        if (openChildWorkflowExecutions() != null) {
            sb.append("OpenChildWorkflowExecutions: ").append(openChildWorkflowExecutions()).append(",");
        }
        if (openLambdaFunctions() != null) {
            sb.append("OpenLambdaFunctions: ").append(openLambdaFunctions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionOpenCountsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
        /**
         * <p>
         * The count of activity tasks whose status is OPEN.
         * </p>
         * 
         * @param openActivityTasks
         *        The count of activity tasks whose status is OPEN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openActivityTasks(Integer openActivityTasks);

        /**
         * <p>
         * The count of decision tasks whose status is OPEN. A workflow execution can have at most one open decision
         * task.
         * </p>
         * 
         * @param openDecisionTasks
         *        The count of decision tasks whose status is OPEN. A workflow execution can have at most one open
         *        decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openDecisionTasks(Integer openDecisionTasks);

        /**
         * <p>
         * The count of timers started by this workflow execution that have not fired yet.
         * </p>
         * 
         * @param openTimers
         *        The count of timers started by this workflow execution that have not fired yet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openTimers(Integer openTimers);

        /**
         * <p>
         * The count of child workflow executions whose status is OPEN.
         * </p>
         * 
         * @param openChildWorkflowExecutions
         *        The count of child workflow executions whose status is OPEN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions);

        /**
         * <p>
         * The count of AWS Lambda functions that are currently executing.
         * </p>
         * 
         * @param openLambdaFunctions
         *        The count of AWS Lambda functions that are currently executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openLambdaFunctions(Integer openLambdaFunctions);
    }

    private static final class BuilderImpl implements Builder {
        private Integer openActivityTasks;

        private Integer openDecisionTasks;

        private Integer openTimers;

        private Integer openChildWorkflowExecutions;

        private Integer openLambdaFunctions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionOpenCounts model) {
            setOpenActivityTasks(model.openActivityTasks);
            setOpenDecisionTasks(model.openDecisionTasks);
            setOpenTimers(model.openTimers);
            setOpenChildWorkflowExecutions(model.openChildWorkflowExecutions);
            setOpenLambdaFunctions(model.openLambdaFunctions);
        }

        public final Integer getOpenActivityTasks() {
            return openActivityTasks;
        }

        @Override
        public final Builder openActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
            return this;
        }

        public final void setOpenActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
        }

        public final Integer getOpenDecisionTasks() {
            return openDecisionTasks;
        }

        @Override
        public final Builder openDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
            return this;
        }

        public final void setOpenDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
        }

        public final Integer getOpenTimers() {
            return openTimers;
        }

        @Override
        public final Builder openTimers(Integer openTimers) {
            this.openTimers = openTimers;
            return this;
        }

        public final void setOpenTimers(Integer openTimers) {
            this.openTimers = openTimers;
        }

        public final Integer getOpenChildWorkflowExecutions() {
            return openChildWorkflowExecutions;
        }

        @Override
        public final Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
            return this;
        }

        public final void setOpenChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
        }

        public final Integer getOpenLambdaFunctions() {
            return openLambdaFunctions;
        }

        @Override
        public final Builder openLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
            return this;
        }

        public final void setOpenLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
        }

        @Override
        public WorkflowExecutionOpenCounts build() {
            return new WorkflowExecutionOpenCounts(this);
        }
    }
}
