/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionInfo implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionInfo.Builder, WorkflowExecutionInfo> {
    private final WorkflowExecution execution;

    private final WorkflowType workflowType;

    private final Date startTimestamp;

    private final Date closeTimestamp;

    private final String executionStatus;

    private final String closeStatus;

    private final WorkflowExecution parent;

    private final List<String> tagList;

    private final Boolean cancelRequested;

    private WorkflowExecutionInfo(BuilderImpl builder) {
        this.execution = builder.execution;
        this.workflowType = builder.workflowType;
        this.startTimestamp = builder.startTimestamp;
        this.closeTimestamp = builder.closeTimestamp;
        this.executionStatus = builder.executionStatus;
        this.closeStatus = builder.closeStatus;
        this.parent = builder.parent;
        this.tagList = builder.tagList;
        this.cancelRequested = builder.cancelRequested;
    }

    /**
     * <p>
     * The workflow execution this information is about.
     * </p>
     * 
     * @return The workflow execution this information is about.
     */
    public WorkflowExecution execution() {
        return execution;
    }

    /**
     * <p>
     * The type of the workflow execution.
     * </p>
     * 
     * @return The type of the workflow execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The time when the execution was started.
     * </p>
     * 
     * @return The time when the execution was started.
     */
    public Date startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The time when the workflow execution was closed. Set only if the execution status is CLOSED.
     * </p>
     * 
     * @return The time when the workflow execution was closed. Set only if the execution status is CLOSED.
     */
    public Date closeTimestamp() {
        return closeTimestamp;
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * 
     * @return The current status of the execution.
     * @see ExecutionStatus
     */
    public String executionStatus() {
        return executionStatus;
    }

    /**
     * <p>
     * If the execution status is closed then this specifies how the execution was closed:
     * </p>
     * <ul>
     * <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
     * <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to gracefully clean
     * up before the execution is closed.</li>
     * <li> <code>TERMINATED</code>: the execution was force terminated.</li>
     * <li> <code>FAILED</code>: the execution failed to complete.</li>
     * <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically timed out.</li>
     * <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current execution was
     * completed and a new execution was started to carry on the workflow.</li>
     * </ul>
     * 
     * @return If the execution status is closed then this specifies how the execution was closed:</p>
     *         <ul>
     *         <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
     *         <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to
     *         gracefully clean up before the execution is closed.</li>
     *         <li> <code>TERMINATED</code>: the execution was force terminated.</li>
     *         <li> <code>FAILED</code>: the execution failed to complete.</li>
     *         <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically
     *         timed out.</li>
     *         <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current execution
     *         was completed and a new execution was started to carry on the workflow.</li>
     * @see CloseStatus
     */
    public String closeStatus() {
        return closeStatus;
    }

    /**
     * <p>
     * If this workflow execution is a child of another execution then contains the workflow execution that started this
     * execution.
     * </p>
     * 
     * @return If this workflow execution is a child of another execution then contains the workflow execution that
     *         started this execution.
     */
    public WorkflowExecution parent() {
        return parent;
    }

    /**
     * <p>
     * The list of tags associated with the workflow execution. Tags can be used to identify and list workflow
     * executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
     * </p>
     * 
     * @return The list of tags associated with the workflow execution. Tags can be used to identify and list workflow
     *         executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     * <p>
     * Set to true if a cancellation is requested for this workflow execution.
     * </p>
     * 
     * @return Set to true if a cancellation is requested for this workflow execution.
     */
    public Boolean cancelRequested() {
        return cancelRequested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((execution() == null) ? 0 : execution().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((startTimestamp() == null) ? 0 : startTimestamp().hashCode());
        hashCode = 31 * hashCode + ((closeTimestamp() == null) ? 0 : closeTimestamp().hashCode());
        hashCode = 31 * hashCode + ((executionStatus() == null) ? 0 : executionStatus().hashCode());
        hashCode = 31 * hashCode + ((closeStatus() == null) ? 0 : closeStatus().hashCode());
        hashCode = 31 * hashCode + ((parent() == null) ? 0 : parent().hashCode());
        hashCode = 31 * hashCode + ((tagList() == null) ? 0 : tagList().hashCode());
        hashCode = 31 * hashCode + ((cancelRequested() == null) ? 0 : cancelRequested().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo) obj;
        if (other.execution() == null ^ this.execution() == null) {
            return false;
        }
        if (other.execution() != null && !other.execution().equals(this.execution())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.startTimestamp() == null ^ this.startTimestamp() == null) {
            return false;
        }
        if (other.startTimestamp() != null && !other.startTimestamp().equals(this.startTimestamp())) {
            return false;
        }
        if (other.closeTimestamp() == null ^ this.closeTimestamp() == null) {
            return false;
        }
        if (other.closeTimestamp() != null && !other.closeTimestamp().equals(this.closeTimestamp())) {
            return false;
        }
        if (other.executionStatus() == null ^ this.executionStatus() == null) {
            return false;
        }
        if (other.executionStatus() != null && !other.executionStatus().equals(this.executionStatus())) {
            return false;
        }
        if (other.closeStatus() == null ^ this.closeStatus() == null) {
            return false;
        }
        if (other.closeStatus() != null && !other.closeStatus().equals(this.closeStatus())) {
            return false;
        }
        if (other.parent() == null ^ this.parent() == null) {
            return false;
        }
        if (other.parent() != null && !other.parent().equals(this.parent())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.cancelRequested() == null ^ this.cancelRequested() == null) {
            return false;
        }
        if (other.cancelRequested() != null && !other.cancelRequested().equals(this.cancelRequested())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (execution() != null) {
            sb.append("Execution: ").append(execution()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (startTimestamp() != null) {
            sb.append("StartTimestamp: ").append(startTimestamp()).append(",");
        }
        if (closeTimestamp() != null) {
            sb.append("CloseTimestamp: ").append(closeTimestamp()).append(",");
        }
        if (executionStatus() != null) {
            sb.append("ExecutionStatus: ").append(executionStatus()).append(",");
        }
        if (closeStatus() != null) {
            sb.append("CloseStatus: ").append(closeStatus()).append(",");
        }
        if (parent() != null) {
            sb.append("Parent: ").append(parent()).append(",");
        }
        if (tagList() != null) {
            sb.append("TagList: ").append(tagList()).append(",");
        }
        if (cancelRequested() != null) {
            sb.append("CancelRequested: ").append(cancelRequested()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionInfo> {
        /**
         * <p>
         * The workflow execution this information is about.
         * </p>
         * 
         * @param execution
         *        The workflow execution this information is about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(WorkflowExecution execution);

        /**
         * <p>
         * The type of the workflow execution.
         * </p>
         * 
         * @param workflowType
         *        The type of the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The time when the execution was started.
         * </p>
         * 
         * @param startTimestamp
         *        The time when the execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Date startTimestamp);

        /**
         * <p>
         * The time when the workflow execution was closed. Set only if the execution status is CLOSED.
         * </p>
         * 
         * @param closeTimestamp
         *        The time when the workflow execution was closed. Set only if the execution status is CLOSED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeTimestamp(Date closeTimestamp);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param executionStatus
         *        The current status of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param executionStatus
         *        The current status of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * If the execution status is closed then this specifies how the execution was closed:
         * </p>
         * <ul>
         * <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
         * <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to gracefully
         * clean up before the execution is closed.</li>
         * <li> <code>TERMINATED</code>: the execution was force terminated.</li>
         * <li> <code>FAILED</code>: the execution failed to complete.</li>
         * <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically timed
         * out.</li>
         * <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current execution was
         * completed and a new execution was started to carry on the workflow.</li>
         * </ul>
         * 
         * @param closeStatus
         *        If the execution status is closed then this specifies how the execution was closed:</p>
         *        <ul>
         *        <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
         *        <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to
         *        gracefully clean up before the execution is closed.</li>
         *        <li> <code>TERMINATED</code>: the execution was force terminated.</li>
         *        <li> <code>FAILED</code>: the execution failed to complete.</li>
         *        <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically
         *        timed out.</li>
         *        <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current
         *        execution was completed and a new execution was started to carry on the workflow.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloseStatus
         */
        Builder closeStatus(String closeStatus);

        /**
         * <p>
         * If the execution status is closed then this specifies how the execution was closed:
         * </p>
         * <ul>
         * <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
         * <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to gracefully
         * clean up before the execution is closed.</li>
         * <li> <code>TERMINATED</code>: the execution was force terminated.</li>
         * <li> <code>FAILED</code>: the execution failed to complete.</li>
         * <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically timed
         * out.</li>
         * <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current execution was
         * completed and a new execution was started to carry on the workflow.</li>
         * </ul>
         * 
         * @param closeStatus
         *        If the execution status is closed then this specifies how the execution was closed:</p>
         *        <ul>
         *        <li> <code>COMPLETED</code>: the execution was successfully completed.</li>
         *        <li> <code>CANCELED</code>: the execution was canceled.Cancellation allows the implementation to
         *        gracefully clean up before the execution is closed.</li>
         *        <li> <code>TERMINATED</code>: the execution was force terminated.</li>
         *        <li> <code>FAILED</code>: the execution failed to complete.</li>
         *        <li> <code>TIMED_OUT</code>: the execution did not complete in the alloted time and was automatically
         *        timed out.</li>
         *        <li> <code>CONTINUED_AS_NEW</code>: the execution is logically continued. This means the current
         *        execution was completed and a new execution was started to carry on the workflow.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloseStatus
         */
        Builder closeStatus(CloseStatus closeStatus);

        /**
         * <p>
         * If this workflow execution is a child of another execution then contains the workflow execution that started
         * this execution.
         * </p>
         * 
         * @param parent
         *        If this workflow execution is a child of another execution then contains the workflow execution that
         *        started this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parent(WorkflowExecution parent);

        /**
         * <p>
         * The list of tags associated with the workflow execution. Tags can be used to identify and list workflow
         * executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with the workflow execution. Tags can be used to identify and list
         *        workflow executions of interest through the visibility APIs. A workflow execution can have a maximum
         *        of 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags associated with the workflow execution. Tags can be used to identify and list workflow
         * executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagList(java.util.Collection)} or {@link #withTagList(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagList
         *        The list of tags associated with the workflow execution. Tags can be used to identify and list
         *        workflow executions of interest through the visibility APIs. A workflow execution can have a maximum
         *        of 5 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         * <p>
         * Set to true if a cancellation is requested for this workflow execution.
         * </p>
         * 
         * @param cancelRequested
         *        Set to true if a cancellation is requested for this workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelRequested(Boolean cancelRequested);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowExecution execution;

        private WorkflowType workflowType;

        private Date startTimestamp;

        private Date closeTimestamp;

        private String executionStatus;

        private String closeStatus;

        private WorkflowExecution parent;

        private List<String> tagList;

        private Boolean cancelRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionInfo model) {
            setExecution(model.execution);
            setWorkflowType(model.workflowType);
            setStartTimestamp(model.startTimestamp);
            setCloseTimestamp(model.closeTimestamp);
            setExecutionStatus(model.executionStatus);
            setCloseStatus(model.closeStatus);
            setParent(model.parent);
            setTagList(model.tagList);
            setCancelRequested(model.cancelRequested);
        }

        public final WorkflowExecution getExecution() {
            return execution;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(WorkflowExecution execution) {
            this.execution = execution;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Date getStartTimestamp() {
            return startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Date startTimestamp) {
            this.startTimestamp = StandardMemberCopier.copy(startTimestamp);
            return this;
        }

        public final void setStartTimestamp(Date startTimestamp) {
            this.startTimestamp = StandardMemberCopier.copy(startTimestamp);
        }

        public final Date getCloseTimestamp() {
            return closeTimestamp;
        }

        @Override
        public final Builder closeTimestamp(Date closeTimestamp) {
            this.closeTimestamp = StandardMemberCopier.copy(closeTimestamp);
            return this;
        }

        public final void setCloseTimestamp(Date closeTimestamp) {
            this.closeTimestamp = StandardMemberCopier.copy(closeTimestamp);
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final void setExecutionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
        }

        public final String getCloseStatus() {
            return closeStatus;
        }

        @Override
        public final Builder closeStatus(String closeStatus) {
            this.closeStatus = closeStatus;
            return this;
        }

        @Override
        public final Builder closeStatus(CloseStatus closeStatus) {
            this.closeStatus(closeStatus.toString());
            return this;
        }

        public final void setCloseStatus(String closeStatus) {
            this.closeStatus = closeStatus;
        }

        public final void setCloseStatus(CloseStatus closeStatus) {
            this.closeStatus(closeStatus.toString());
        }

        public final WorkflowExecution getParent() {
            return parent;
        }

        @Override
        public final Builder parent(WorkflowExecution parent) {
            this.parent = parent;
            return this;
        }

        public final void setParent(WorkflowExecution parent) {
            this.parent = parent;
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final Boolean getCancelRequested() {
            return cancelRequested;
        }

        @Override
        public final Builder cancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            return this;
        }

        public final void setCancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
        }

        @Override
        public WorkflowExecutionInfo build() {
            return new WorkflowExecutionInfo(this);
        }
    }
}
