/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter the workflow executions in visibility APIs by their <code>workflowId</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionFilter implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionFilter.Builder, WorkflowExecutionFilter> {
    private final String workflowId;

    private WorkflowExecutionFilter(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
    }

    /**
     * <p>
     * The workflowId to pass of match the criteria of this filter.
     * </p>
     * 
     * @return The workflowId to pass of match the criteria of this filter.
     */
    public String workflowId() {
        return workflowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionFilter)) {
            return false;
        }
        WorkflowExecutionFilter other = (WorkflowExecutionFilter) obj;
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionFilter> {
        /**
         * <p>
         * The workflowId to pass of match the criteria of this filter.
         * </p>
         * 
         * @param workflowId
         *        The workflowId to pass of match the criteria of this filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);
    }

    private static final class BuilderImpl implements Builder {
        private String workflowId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionFilter model) {
            setWorkflowId(model.workflowId);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public WorkflowExecutionFilter build() {
            return new WorkflowExecutionFilter(this);
        }
    }
}
