/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionCanceledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>WorkflowExecutionCanceled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionCanceledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionCanceledEventAttributes.Builder, WorkflowExecutionCanceledEventAttributes> {
    private final String details;

    private final Long decisionTaskCompletedEventId;

    private WorkflowExecutionCanceledEventAttributes(BuilderImpl builder) {
        this.details = builder.details;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * Details for the cancellation (if any).
     * </p>
     * 
     * @return Details for the cancellation (if any).
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can
     *         be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionCanceledEventAttributes)) {
            return false;
        }
        WorkflowExecutionCanceledEventAttributes other = (WorkflowExecutionCanceledEventAttributes) obj;
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionCanceledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionCanceledEventAttributes> {
        /**
         * <p>
         * Details for the cancellation (if any).
         * </p>
         * 
         * @param details
         *        Details for the cancellation (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>CancelWorkflowExecution</code> decision for this cancellation request. This information can be
         * useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>CancelWorkflowExecution</code> decision for this cancellation request. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String details;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionCanceledEventAttributes model) {
            setDetails(model.details);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public WorkflowExecutionCanceledEventAttributes build() {
            return new WorkflowExecutionCanceledEventAttributes(this);
        }
    }
}
