/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.TimerFiredEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>TimerFired</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimerFiredEventAttributes implements StructuredPojo,
        ToCopyableBuilder<TimerFiredEventAttributes.Builder, TimerFiredEventAttributes> {
    private final String timerId;

    private final Long startedEventId;

    private TimerFiredEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The unique ID of the timer that fired.
     * </p>
     * 
     * @return The unique ID of the timer that fired.
     */
    public String timerId() {
        return timerId;
    }

    /**
     * <p>
     * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information can
     * be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timerId() == null) ? 0 : timerId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerFiredEventAttributes)) {
            return false;
        }
        TimerFiredEventAttributes other = (TimerFiredEventAttributes) obj;
        if (other.timerId() == null ^ this.timerId() == null) {
            return false;
        }
        if (other.timerId() != null && !other.timerId().equals(this.timerId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timerId() != null) {
            sb.append("TimerId: ").append(timerId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimerFiredEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimerFiredEventAttributes> {
        /**
         * <p>
         * The unique ID of the timer that fired.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer that fired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information
         * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String timerId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(TimerFiredEventAttributes model) {
            setTimerId(model.timerId);
            setStartedEventId(model.startedEventId);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public TimerFiredEventAttributes build() {
            return new TimerFiredEventAttributes(this);
        }
    }
}
