/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TerminateWorkflowExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TerminateWorkflowExecutionRequest.Builder, TerminateWorkflowExecutionRequest> {
    private final String domain;

    private final String workflowId;

    private final String runId;

    private final String reason;

    private final String details;

    private final String childPolicy;

    private TerminateWorkflowExecutionRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.reason = builder.reason;
        this.details = builder.details;
        this.childPolicy = builder.childPolicy;
    }

    /**
     * <p>
     * The domain of the workflow execution to terminate.
     * </p>
     * 
     * @return The domain of the workflow execution to terminate.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflowId of the workflow execution to terminate.
     * </p>
     * 
     * @return The workflowId of the workflow execution to terminate.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The runId of the workflow execution to terminate.
     * </p>
     * 
     * @return The runId of the workflow execution to terminate.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * <i>Optional.</i> A descriptive reason for terminating the workflow execution.
     * </p>
     * 
     * @return Optional.
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * <i>Optional.</i> Details for terminating the workflow execution.
     * </p>
     * 
     * @return Optional.
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated.
     * This policy overrides the child policy specified for the workflow execution at registration time or when starting
     * the execution.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * <note>A child policy for this workflow execution must be specified either as a default for the workflow type or
     * through this parameter. If neither this parameter is set nor a default child policy was specified at registration
     * time then a fault will be returned.</note>
     * 
     * @return If set, specifies the policy to use for the child workflow executions of the workflow execution being
     *         terminated. This policy overrides the child policy specified for the workflow execution at registration
     *         time or when starting the execution.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     *         </ul>
     *         <note>A child policy for this workflow execution must be specified either as a default for the workflow
     *         type or through this parameter. If neither this parameter is set nor a default child policy was specified
     *         at registration time then a fault will be returned.
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateWorkflowExecutionRequest)) {
            return false;
        }
        TerminateWorkflowExecutionRequest other = (TerminateWorkflowExecutionRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TerminateWorkflowExecutionRequest> {
        /**
         * <p>
         * The domain of the workflow execution to terminate.
         * </p>
         * 
         * @param domain
         *        The domain of the workflow execution to terminate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflowId of the workflow execution to terminate.
         * </p>
         * 
         * @param workflowId
         *        The workflowId of the workflow execution to terminate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The runId of the workflow execution to terminate.
         * </p>
         * 
         * @param runId
         *        The runId of the workflow execution to terminate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * <i>Optional.</i> A descriptive reason for terminating the workflow execution.
         * </p>
         * 
         * @param reason
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * <i>Optional.</i> Details for terminating the workflow execution.
         * </p>
         * 
         * @param details
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * If set, specifies the policy to use for the child workflow executions of the workflow execution being
         * terminated. This policy overrides the child policy specified for the workflow execution at registration time
         * or when starting the execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        If set, specifies the policy to use for the child workflow executions of the workflow execution being
         *        terminated. This policy overrides the child policy specified for the workflow execution at
         *        registration time or when starting the execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         *        <note>A child policy for this workflow execution must be specified either as a default for the
         *        workflow type or through this parameter. If neither this parameter is set nor a default child policy
         *        was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * If set, specifies the policy to use for the child workflow executions of the workflow execution being
         * terminated. This policy overrides the child policy specified for the workflow execution at registration time
         * or when starting the execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        If set, specifies the policy to use for the child workflow executions of the workflow execution being
         *        terminated. This policy overrides the child policy specified for the workflow execution at
         *        registration time or when starting the execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         *        <note>A child policy for this workflow execution must be specified either as a default for the
         *        workflow type or through this parameter. If neither this parameter is set nor a default child policy
         *        was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private String workflowId;

        private String runId;

        private String reason;

        private String details;

        private String childPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateWorkflowExecutionRequest model) {
            setDomain(model.domain);
            setWorkflowId(model.workflowId);
            setRunId(model.runId);
            setReason(model.reason);
            setDetails(model.details);
            setChildPolicy(model.childPolicy);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        @Override
        public TerminateWorkflowExecutionRequest build() {
            return new TerminateWorkflowExecutionRequest(this);
        }
    }
}
