/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StartWorkflowExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StartWorkflowExecutionRequest.Builder, StartWorkflowExecutionRequest> {
    private final String domain;

    private final String workflowId;

    private final WorkflowType workflowType;

    private final TaskList taskList;

    private final String taskPriority;

    private final String input;

    private final String executionStartToCloseTimeout;

    private final List<String> tagList;

    private final String taskStartToCloseTimeout;

    private final String childPolicy;

    private final String lambdaRole;

    private StartWorkflowExecutionRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.tagList = builder.tagList;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The name of the domain in which the workflow execution is created.
     * </p>
     * 
     * @return The name of the domain in which the workflow execution is created.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The user defined identifier associated with the workflow execution. You can use this to associate a custom
     * identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically
     * a <i>restart</i> of a previous execution. You cannot have two open workflow executions with the same
     * <code>workflowId</code> at the same time.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The user defined identifier associated with the workflow execution. You can use this to associate a
     *         custom identifier with the workflow execution. You may specify the same identifier if a workflow
     *         execution is logically a <i>restart</i> of a previous execution. You cannot have two open workflow
     *         executions with the same <code>workflowId</code> at the same time.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The type of the workflow to start.
     * </p>
     * 
     * @return The type of the workflow to start.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The task list to use for the decision tasks generated for this workflow execution. This overrides the
     * <code>defaultTaskList</code> specified when registering the workflow type.
     * </p>
     * <note>A task list for this workflow execution must be specified either as a default for the workflow type or
     * through this parameter. If neither this parameter is set nor a default task list was specified at registration
     * time then a fault will be returned.</note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The task list to use for the decision tasks generated for this workflow execution. This overrides the
     *         <code>defaultTaskList</code> specified when registering the workflow type.</p> <note>A task list for this
     *         workflow execution must be specified either as a default for the workflow type or through this parameter.
     *         If neither this parameter is set nor a default task list was specified at registration time then a fault
     *         will be returned.</note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The task priority to use for this workflow execution. This will override any default priority that was assigned
     * when the workflow type was registered. If not set, then the default task priority for the workflow type will be
     * used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return The task priority to use for this workflow execution. This will override any default priority that was
     *         assigned when the workflow type was registered. If not set, then the default task priority for the
     *         workflow type will be used. Valid values are integers that range from Java's
     *         <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
     *         numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The input for the workflow execution. This is a free form string which should be meaningful to the workflow you
     * are starting. This <code>input</code> is made available to the new workflow execution in the
     * <code>WorkflowExecutionStarted</code> history event.
     * </p>
     * 
     * @return The input for the workflow execution. This is a free form string which should be meaningful to the
     *         workflow you are starting. This <code>input</code> is made available to the new workflow execution in the
     *         <code>WorkflowExecutionStarted</code> history event.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified
     * when registering the workflow type.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. Exceeding this limit will cause the
     * workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a
     * value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.
     * </p>
     * <note> An execution start-to-close timeout must be specified either through this parameter or as a default when
     * the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is
     * specified, a fault is returned.</note>
     * 
     * @return The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
     *         specified when registering the workflow type.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. Exceeding this limit will
     *         cause the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you
     *         cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a
     *         workflow execution can run.
     *         </p>
     *         <note> An execution start-to-close timeout must be specified either through this parameter or as a
     *         default when the workflow type is registered. If neither this parameter nor a default execution
     *         start-to-close timeout is specified, a fault is returned.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list
     * workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
     * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
     * </p>
     * 
     * @return The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can
     *         list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
     *         <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     * <p>
     * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
     * <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
     * <a>RegisterWorkflowType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>A task start-to-close timeout for this workflow execution must be specified either as a default for the
     * workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close
     * timeout was specified at registration time then a fault will be returned.</note>
     * 
     * @return Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides
     *         the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
     *         <a>RegisterWorkflowType</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     *         <note>A task start-to-close timeout for this workflow execution must be specified either as a default for
     *         the workflow type or through this parameter. If neither this parameter is set nor a default task
     *         start-to-close timeout was specified at registration time then a fault will be returned.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the policy to use for the child workflow executions of this workflow execution if it is
     * terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout. This
     * policy overrides the default child policy specified when registering the workflow type using
     * <a>RegisterWorkflowType</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * <note>A child policy for this workflow execution must be specified either as a default for the workflow type or
     * through this parameter. If neither this parameter is set nor a default child policy was specified at registration
     * time then a fault will be returned.</note>
     * 
     * @return If set, specifies the policy to use for the child workflow executions of this workflow execution if it is
     *         terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     *         timeout. This policy overrides the default child policy specified when registering the workflow type
     *         using <a>RegisterWorkflowType</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     *         </ul>
     *         <note>A child policy for this workflow execution must be specified either as a default for the workflow
     *         type or through this parameter. If neither this parameter is set nor a default child policy was specified
     *         at registration time then a fault will be returned.
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    /**
     * <p>
     * The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
     * </p>
     * <note>In order for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be
     * specified either as a default for the workflow type or through this field.</note>
     * 
     * @return The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.</p> <note>In order for
     *         this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be specified either
     *         as a default for the workflow type or through this field.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((executionStartToCloseTimeout() == null) ? 0 : executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((tagList() == null) ? 0 : tagList().hashCode());
        hashCode = 31 * hashCode + ((taskStartToCloseTimeout() == null) ? 0 : taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        hashCode = 31 * hashCode + ((lambdaRole() == null) ? 0 : lambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowExecutionRequest)) {
            return false;
        }
        StartWorkflowExecutionRequest other = (StartWorkflowExecutionRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null
                && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        if (other.lambdaRole() != null && !other.lambdaRole().equals(this.lambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(executionStartToCloseTimeout()).append(",");
        }
        if (tagList() != null) {
            sb.append("TagList: ").append(tagList()).append(",");
        }
        if (taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(taskStartToCloseTimeout()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        if (lambdaRole() != null) {
            sb.append("LambdaRole: ").append(lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StartWorkflowExecutionRequest> {
        /**
         * <p>
         * The name of the domain in which the workflow execution is created.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which the workflow execution is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The user defined identifier associated with the workflow execution. You can use this to associate a custom
         * identifier with the workflow execution. You may specify the same identifier if a workflow execution is
         * logically a <i>restart</i> of a previous execution. You cannot have two open workflow executions with the
         * same <code>workflowId</code> at the same time.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param workflowId
         *        The user defined identifier associated with the workflow execution. You can use this to associate a
         *        custom identifier with the workflow execution. You may specify the same identifier if a workflow
         *        execution is logically a <i>restart</i> of a previous execution. You cannot have two open workflow
         *        executions with the same <code>workflowId</code> at the same time.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The type of the workflow to start.
         * </p>
         * 
         * @param workflowType
         *        The type of the workflow to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The task list to use for the decision tasks generated for this workflow execution. This overrides the
         * <code>defaultTaskList</code> specified when registering the workflow type.
         * </p>
         * <note>A task list for this workflow execution must be specified either as a default for the workflow type or
         * through this parameter. If neither this parameter is set nor a default task list was specified at
         * registration time then a fault will be returned.</note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param taskList
         *        The task list to use for the decision tasks generated for this workflow execution. This overrides the
         *        <code>defaultTaskList</code> specified when registering the workflow type.</p> <note>A task list for
         *        this workflow execution must be specified either as a default for the workflow type or through this
         *        parameter. If neither this parameter is set nor a default task list was specified at registration time
         *        then a fault will be returned.</note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The task priority to use for this workflow execution. This will override any default priority that was
         * assigned when the workflow type was registered. If not set, then the default task priority for the workflow
         * type will be used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
         * (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        The task priority to use for this workflow execution. This will override any default priority that was
         *        assigned when the workflow type was registered. If not set, then the default task priority for the
         *        workflow type will be used. Valid values are integers that range from Java's
         *        <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
         *        numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The input for the workflow execution. This is a free form string which should be meaningful to the workflow
         * you are starting. This <code>input</code> is made available to the new workflow execution in the
         * <code>WorkflowExecutionStarted</code> history event.
         * </p>
         * 
         * @param input
         *        The input for the workflow execution. This is a free form string which should be meaningful to the
         *        workflow you are starting. This <code>input</code> is made available to the new workflow execution in
         *        the <code>WorkflowExecutionStarted</code> history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
         * specified when registering the workflow type.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. Exceeding this limit will cause
         * the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot
         * specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow
         * execution can run.
         * </p>
         * <note> An execution start-to-close timeout must be specified either through this parameter or as a default
         * when the workflow type is registered. If neither this parameter nor a default execution start-to-close
         * timeout is specified, a fault is returned.</note>
         * 
         * @param executionStartToCloseTimeout
         *        The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
         *        specified when registering the workflow type.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. Exceeding this limit will
         *        cause the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF,
         *        you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that
         *        a workflow execution can run.
         *        </p>
         *        <note> An execution start-to-close timeout must be specified either through this parameter or as a
         *        default when the workflow type is registered. If neither this parameter nor a default execution
         *        start-to-close timeout is specified, a fault is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list
         * workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You
         *        can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         *        <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list
         * workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagList(java.util.Collection)} or {@link #withTagList(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You
         *        can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         *        <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         * <p>
         * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
         * <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
         * <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>A task start-to-close timeout for this workflow execution must be specified either as a default for the
         * workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close
         * timeout was specified at registration time then a fault will be returned.</note>
         * 
         * @param taskStartToCloseTimeout
         *        Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides
         *        the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
         *        <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         *        <note>A task start-to-close timeout for this workflow execution must be specified either as a default
         *        for the workflow type or through this parameter. If neither this parameter is set nor a default task
         *        start-to-close timeout was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the policy to use for the child workflow executions of this workflow execution if it is
         * terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * This policy overrides the default child policy specified when registering the workflow type using
         * <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        If set, specifies the policy to use for the child workflow executions of this workflow execution if it
         *        is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
         *        timeout. This policy overrides the default child policy specified when registering the workflow type
         *        using <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         *        <note>A child policy for this workflow execution must be specified either as a default for the
         *        workflow type or through this parameter. If neither this parameter is set nor a default child policy
         *        was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * If set, specifies the policy to use for the child workflow executions of this workflow execution if it is
         * terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * This policy overrides the default child policy specified when registering the workflow type using
         * <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        If set, specifies the policy to use for the child workflow executions of this workflow execution if it
         *        is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
         *        timeout. This policy overrides the default child policy specified when registering the workflow type
         *        using <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         *        <note>A child policy for this workflow execution must be specified either as a default for the
         *        workflow type or through this parameter. If neither this parameter is set nor a default child policy
         *        was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
         * </p>
         * <note>In order for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be
         * specified either as a default for the workflow type or through this field.</note>
         * 
         * @param lambdaRole
         *        The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.</p> <note>In order
         *        for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be specified
         *        either as a default for the workflow type or through this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private String workflowId;

        private WorkflowType workflowType;

        private TaskList taskList;

        private String taskPriority;

        private String input;

        private String executionStartToCloseTimeout;

        private List<String> tagList;

        private String taskStartToCloseTimeout;

        private String childPolicy;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowExecutionRequest model) {
            setDomain(model.domain);
            setWorkflowId(model.workflowId);
            setWorkflowType(model.workflowType);
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setInput(model.input);
            setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            setTagList(model.tagList);
            setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            setChildPolicy(model.childPolicy);
            setLambdaRole(model.lambdaRole);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public StartWorkflowExecutionRequest build() {
            return new StartWorkflowExecutionRequest(this);
        }
    }
}
