/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.SignalExternalWorkflowExecutionInitiatedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>SignalExternalWorkflowExecutionInitiated</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SignalExternalWorkflowExecutionInitiatedEventAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder, SignalExternalWorkflowExecutionInitiatedEventAttributes> {
    private final String workflowId;

    private final String runId;

    private final String signalName;

    private final String input;

    private final Long decisionTaskCompletedEventId;

    private final String control;

    private SignalExternalWorkflowExecutionInitiatedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.signalName = builder.signalName;
        this.input = builder.input;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the external workflow execution.
     * </p>
     * 
     * @return The <code>workflowId</code> of the external workflow execution.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the external workflow execution to send the signal to.
     * </p>
     * 
     * @return The <code>runId</code> of the external workflow execution to send the signal to.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the signal.
     * </p>
     * 
     * @return The name of the signal.
     */
    public String signalName() {
        return signalName;
    }

    /**
     * <p>
     * Input provided to the signal (if any).
     * </p>
     * 
     * @return Input provided to the signal (if any).
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * <i>Optional.</i> data attached to the event that can be used by the decider in subsequent decision tasks.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        hashCode = 31 * hashCode + ((signalName() == null) ? 0 : signalName().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalExternalWorkflowExecutionInitiatedEventAttributes)) {
            return false;
        }
        SignalExternalWorkflowExecutionInitiatedEventAttributes other = (SignalExternalWorkflowExecutionInitiatedEventAttributes) obj;
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        if (other.signalName() == null ^ this.signalName() == null) {
            return false;
        }
        if (other.signalName() != null && !other.signalName().equals(this.signalName())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        if (signalName() != null) {
            sb.append("SignalName: ").append(signalName()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SignalExternalWorkflowExecutionInitiatedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SignalExternalWorkflowExecutionInitiatedEventAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the external workflow execution.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the external workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the external workflow execution to send the signal to.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the external workflow execution to send the signal to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the signal.
         * </p>
         * 
         * @param signalName
         *        The name of the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalName(String signalName);

        /**
         * <p>
         * Input provided to the signal (if any).
         * </p>
         * 
         * @param input
         *        Input provided to the signal (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * <i>Optional.</i> data attached to the event that can be used by the decider in subsequent decision tasks.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    private static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private String signalName;

        private String input;

        private Long decisionTaskCompletedEventId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalExternalWorkflowExecutionInitiatedEventAttributes model) {
            setWorkflowId(model.workflowId);
            setRunId(model.runId);
            setSignalName(model.signalName);
            setInput(model.input);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            setControl(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getSignalName() {
            return signalName;
        }

        @Override
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public SignalExternalWorkflowExecutionInitiatedEventAttributes build() {
            return new SignalExternalWorkflowExecutionInitiatedEventAttributes(this);
        }
    }
}
