/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.SignalExternalWorkflowExecutionFailedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>SignalExternalWorkflowExecutionFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SignalExternalWorkflowExecutionFailedEventAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<SignalExternalWorkflowExecutionFailedEventAttributes.Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
    private final String workflowId;

    private final String runId;

    private final String cause;

    private final Long initiatedEventId;

    private final Long decisionTaskCompletedEventId;

    private final String control;

    private SignalExternalWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.cause = builder.cause;
        this.initiatedEventId = builder.initiatedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
     * </p>
     * 
     * @return The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the external workflow execution that the signal was being delivered to.
     * </p>
     * 
     * @return The <code>runId</code> of the external workflow execution that the signal was being delivered to.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
     * permissions. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.</note>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a>.
     * @see SignalExternalWorkflowExecutionFailedCause
     */
    public String cause() {
        return cause;
    }

    /**
     * <p>
     * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     *
     * @return
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        hashCode = 31 * hashCode + ((cause() == null) ? 0 : cause().hashCode());
        hashCode = 31 * hashCode + ((initiatedEventId() == null) ? 0 : initiatedEventId().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalExternalWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        SignalExternalWorkflowExecutionFailedEventAttributes other = (SignalExternalWorkflowExecutionFailedEventAttributes) obj;
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        if (other.initiatedEventId() == null ^ this.initiatedEventId() == null) {
            return false;
        }
        if (other.initiatedEventId() != null && !other.initiatedEventId().equals(this.initiatedEventId())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        if (cause() != null) {
            sb.append("Cause: ").append(cause()).append(",");
        }
        if (initiatedEventId() != null) {
            sb.append("InitiatedEventId: ").append(initiatedEventId()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SignalExternalWorkflowExecutionFailedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the external workflow execution that the signal was being delivered to.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the external workflow execution that the signal was being delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
         * permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a>.</note>
         * 
         * @param cause
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalExternalWorkflowExecutionFailedCause
         */
        Builder cause(String cause);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
         * permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a>.</note>
         * 
         * @param cause
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalExternalWorkflowExecutionFailedCause
         */
        Builder cause(SignalExternalWorkflowExecutionFailedCause cause);

        /**
         * <p>
         * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful
         * for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         *
         * @param control
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    private static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private String cause;

        private Long initiatedEventId;

        private Long decisionTaskCompletedEventId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalExternalWorkflowExecutionFailedEventAttributes model) {
            setWorkflowId(model.workflowId);
            setRunId(model.runId);
            setCause(model.cause);
            setInitiatedEventId(model.initiatedEventId);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            setControl(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(SignalExternalWorkflowExecutionFailedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final void setCause(SignalExternalWorkflowExecutionFailedCause cause) {
            this.cause(cause.toString());
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public SignalExternalWorkflowExecutionFailedEventAttributes build() {
            return new SignalExternalWorkflowExecutionFailedEventAttributes(this);
        }
    }
}
