/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ScheduleActivityTaskDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ScheduleActivityTask</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
 * <ul>
 * <li><code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</li>
 * <li><code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</li>
 * <li><code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.</li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleActivityTaskDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<ScheduleActivityTaskDecisionAttributes.Builder, ScheduleActivityTaskDecisionAttributes> {
    private final ActivityType activityType;

    private final String activityId;

    private final String control;

    private final String input;

    private final String scheduleToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final String scheduleToStartTimeout;

    private final String startToCloseTimeout;

    private final String heartbeatTimeout;

    private ScheduleActivityTaskDecisionAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.control = builder.control;
        this.input = builder.input;
        this.scheduleToCloseTimeout = builder.scheduleToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.scheduleToStartTimeout = builder.scheduleToStartTimeout;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.heartbeatTimeout = builder.heartbeatTimeout;
    }

    /**
     * <p>
     * <b>Required.</b> The type of the activity task to schedule.
     * </p>
     * 
     * @return Required.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * <b>Required.</b> The <code>activityId</code> of the activity task.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Required.</b> The <code>activityId</code> of the activity task.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks. This
     * data is not sent to the activity.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * The input provided to the activity task.
     * </p>
     * 
     * @return The input provided to the activity task.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum duration for this activity task.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>A schedule-to-close timeout for this activity task must be specified either as a default for the activity
     * type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at
     * registration time then a fault will be returned.</note>
     * 
     * @return The maximum duration for this activity task.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     *         <note>A schedule-to-close timeout for this activity task must be specified either as a default for the
     *         activity type or through this field. If neither this field is set nor a default schedule-to-close timeout
     *         was specified at registration time then a fault will be returned.
     */
    public String scheduleToCloseTimeout() {
        return scheduleToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
     * <code>defaultTaskList</code> registered with the activity type will be used.
     * </p>
     * <note>A task list for this activity task must be specified either as a default for the activity type or through
     * this field. If neither this field is set nor a default task list was specified at registration time then a fault
     * will be returned.</note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
     *         <code>defaultTaskList</code> registered with the activity type will be used.</p> <note>A task list for
     *         this activity task must be specified either as a default for the activity type or through this field. If
     *         neither this field is set nor a default task list was specified at registration time then a fault will be
     *         returned.</note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * <i>Optional.</i> If set, specifies the priority with which the activity task is to be assigned to a worker. This
     * overrides the defaultTaskPriority specified when registering the activity type using <a>RegisterActivityType</a>.
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> If set, specifies the priority with which the activity task is to be assigned to a worker.
     *         This overrides the defaultTaskPriority specified when registering the activity type using
     *         <a>RegisterActivityType</a>. Valid values are integers that range from Java's
     *         <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
     *         numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * <i>Optional.</i> If set, specifies the maximum duration the activity task can wait to be assigned to a worker.
     * This overrides the default schedule-to-start timeout specified when registering the activity type using
     * <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>A schedule-to-start timeout for this activity task must be specified either as a default for the activity
     * type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at
     * registration time then a fault will be returned.</note>
     * 
     * @return Optional.</i> If set, specifies the maximum duration the activity task can wait to be assigned to a
     *         worker. This overrides the default schedule-to-start timeout specified when registering the activity type
     *         using <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     */
    public String scheduleToStartTimeout() {
        return scheduleToStartTimeout;
    }

    /**
     * <p>
     * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
     * default start-to-close timeout specified when registering the activity type using <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>A start-to-close timeout for this activity task must be specified either as a default for the activity type
     * or through this field. If neither this field is set nor a default start-to-close timeout was specified at
     * registration time then a fault will be returned.</note>
     * 
     * @return If set, specifies the maximum duration a worker may take to process this activity task. This overrides
     *         the default start-to-close timeout specified when registering the activity type using
     *         <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     *         <note>A start-to-close timeout for this activity task must be specified either as a default for the
     *         activity type or through this field. If neither this field is set nor a default start-to-close timeout
     *         was specified at registration time then a fault will be returned.
     */
    public String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the maximum time before which a worker processing a task of this type must report progress by
     * calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
     * out. If the worker subsequently attempts to record a heartbeat or returns a result, it will be ignored. This
     * overrides the default heartbeat timeout specified when registering the activity type using
     * <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the maximum time before which a worker processing a task of this type must report
     *         progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
     *         automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a result,
     *         it will be ignored. This overrides the default heartbeat timeout specified when registering the activity
     *         type using <a>RegisterActivityType</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String heartbeatTimeout() {
        return heartbeatTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityType() == null) ? 0 : activityType().hashCode());
        hashCode = 31 * hashCode + ((activityId() == null) ? 0 : activityId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((scheduleToCloseTimeout() == null) ? 0 : scheduleToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((scheduleToStartTimeout() == null) ? 0 : scheduleToStartTimeout().hashCode());
        hashCode = 31 * hashCode + ((startToCloseTimeout() == null) ? 0 : startToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((heartbeatTimeout() == null) ? 0 : heartbeatTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActivityTaskDecisionAttributes)) {
            return false;
        }
        ScheduleActivityTaskDecisionAttributes other = (ScheduleActivityTaskDecisionAttributes) obj;
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.scheduleToCloseTimeout() == null ^ this.scheduleToCloseTimeout() == null) {
            return false;
        }
        if (other.scheduleToCloseTimeout() != null && !other.scheduleToCloseTimeout().equals(this.scheduleToCloseTimeout())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.scheduleToStartTimeout() == null ^ this.scheduleToStartTimeout() == null) {
            return false;
        }
        if (other.scheduleToStartTimeout() != null && !other.scheduleToStartTimeout().equals(this.scheduleToStartTimeout())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        if (other.startToCloseTimeout() != null && !other.startToCloseTimeout().equals(this.startToCloseTimeout())) {
            return false;
        }
        if (other.heartbeatTimeout() == null ^ this.heartbeatTimeout() == null) {
            return false;
        }
        if (other.heartbeatTimeout() != null && !other.heartbeatTimeout().equals(this.heartbeatTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityType() != null) {
            sb.append("ActivityType: ").append(activityType()).append(",");
        }
        if (activityId() != null) {
            sb.append("ActivityId: ").append(activityId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (scheduleToCloseTimeout() != null) {
            sb.append("ScheduleToCloseTimeout: ").append(scheduleToCloseTimeout()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (scheduleToStartTimeout() != null) {
            sb.append("ScheduleToStartTimeout: ").append(scheduleToStartTimeout()).append(",");
        }
        if (startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(startToCloseTimeout()).append(",");
        }
        if (heartbeatTimeout() != null) {
            sb.append("HeartbeatTimeout: ").append(heartbeatTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleActivityTaskDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleActivityTaskDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The type of the activity task to schedule.
         * </p>
         * 
         * @param activityType
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * <b>Required.</b> The <code>activityId</code> of the activity task.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param activityId
         *        Required.</b> The <code>activityId</code> of the activity task.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * This data is not sent to the activity.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The input provided to the activity task.
         * </p>
         * 
         * @param input
         *        The input provided to the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum duration for this activity task.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>A schedule-to-close timeout for this activity task must be specified either as a default for the
         * activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was
         * specified at registration time then a fault will be returned.</note>
         * 
         * @param scheduleToCloseTimeout
         *        The maximum duration for this activity task.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         *        <note>A schedule-to-close timeout for this activity task must be specified either as a default for the
         *        activity type or through this field. If neither this field is set nor a default schedule-to-close
         *        timeout was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToCloseTimeout(String scheduleToCloseTimeout);

        /**
         * <p>
         * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the
         * <code>defaultTaskList</code> registered with the activity type will be used.
         * </p>
         * <note>A task list for this activity task must be specified either as a default for the activity type or
         * through this field. If neither this field is set nor a default task list was specified at registration time
         * then a fault will be returned.</note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param taskList
         *        If set, specifies the name of the task list in which to schedule the activity task. If not specified,
         *        the <code>defaultTaskList</code> registered with the activity type will be used.</p> <note>A task list
         *        for this activity task must be specified either as a default for the activity type or through this
         *        field. If neither this field is set nor a default task list was specified at registration time then a
         *        fault will be returned.</note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * <i>Optional.</i> If set, specifies the priority with which the activity task is to be assigned to a worker.
         * This overrides the defaultTaskPriority specified when registering the activity type using
         * <a>RegisterActivityType</a>. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code>
         * (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        Optional.</i> If set, specifies the priority with which the activity task is to be assigned to a
         *        worker. This overrides the defaultTaskPriority specified when registering the activity type using
         *        <a>RegisterActivityType</a>. Valid values are integers that range from Java's
         *        <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
         *        numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * <i>Optional.</i> If set, specifies the maximum duration the activity task can wait to be assigned to a
         * worker. This overrides the default schedule-to-start timeout specified when registering the activity type
         * using <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>A schedule-to-start timeout for this activity task must be specified either as a default for the
         * activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was
         * specified at registration time then a fault will be returned.</note>
         * 
         * @param scheduleToStartTimeout
         *        Optional.</i> If set, specifies the maximum duration the activity task can wait to be assigned to a
         *        worker. This overrides the default schedule-to-start timeout specified when registering the activity
         *        type using <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToStartTimeout(String scheduleToStartTimeout);

        /**
         * <p>
         * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the
         * default start-to-close timeout specified when registering the activity type using
         * <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>A start-to-close timeout for this activity task must be specified either as a default for the activity
         * type or through this field. If neither this field is set nor a default start-to-close timeout was specified
         * at registration time then a fault will be returned.</note>
         * 
         * @param startToCloseTimeout
         *        If set, specifies the maximum duration a worker may take to process this activity task. This overrides
         *        the default start-to-close timeout specified when registering the activity type using
         *        <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         *        <note>A start-to-close timeout for this activity task must be specified either as a default for the
         *        activity type or through this field. If neither this field is set nor a default start-to-close timeout
         *        was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * If set, specifies the maximum time before which a worker processing a task of this type must report progress
         * by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically
         * timed out. If the worker subsequently attempts to record a heartbeat or returns a result, it will be ignored.
         * This overrides the default heartbeat timeout specified when registering the activity type using
         * <a>RegisterActivityType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param heartbeatTimeout
         *        If set, specifies the maximum time before which a worker processing a task of this type must report
         *        progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task
         *        is automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a
         *        result, it will be ignored. This overrides the default heartbeat timeout specified when registering
         *        the activity type using <a>RegisterActivityType</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(String heartbeatTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String activityId;

        private String control;

        private String input;

        private String scheduleToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private String scheduleToStartTimeout;

        private String startToCloseTimeout;

        private String heartbeatTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActivityTaskDecisionAttributes model) {
            setActivityType(model.activityType);
            setActivityId(model.activityId);
            setControl(model.control);
            setInput(model.input);
            setScheduleToCloseTimeout(model.scheduleToCloseTimeout);
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setScheduleToStartTimeout(model.scheduleToStartTimeout);
            setStartToCloseTimeout(model.startToCloseTimeout);
            setHeartbeatTimeout(model.heartbeatTimeout);
        }

        public final ActivityType getActivityType() {
            return activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getScheduleToCloseTimeout() {
            return scheduleToCloseTimeout;
        }

        @Override
        public final Builder scheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public final void setScheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getScheduleToStartTimeout() {
            return scheduleToStartTimeout;
        }

        @Override
        public final Builder scheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public final void setScheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        public final String getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public ScheduleActivityTaskDecisionAttributes build() {
            return new ScheduleActivityTaskDecisionAttributes(this);
        }
    }
}
