/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RespondDecisionTaskCompletedRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RespondDecisionTaskCompletedRequest.Builder, RespondDecisionTaskCompletedRequest> {
    private final String taskToken;

    private final List<Decision> decisions;

    private final String executionContext;

    private RespondDecisionTaskCompletedRequest(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.decisions = builder.decisions;
        this.executionContext = builder.executionContext;
    }

    /**
     * <p>
     * The <code>taskToken</code> from the <a>DecisionTask</a>.
     * </p>
     * <important><code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
     * task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</important>
     * 
     * @return The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important><code>taskToken</code> is
     *         generated by the service and should be treated as an opaque value. If the task is passed to another
     *         process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
     *         respond with results.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for
     * the decision structure for details.
     * </p>
     * 
     * @return The list of decisions (possibly empty) made by the decider while processing this decision task. See the
     *         docs for the decision structure for details.
     */
    public List<Decision> decisions() {
        return decisions;
    }

    /**
     * <p>
     * User defined context to add to workflow execution.
     * </p>
     * 
     * @return User defined context to add to workflow execution.
     */
    public String executionContext() {
        return executionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskToken() == null) ? 0 : taskToken().hashCode());
        hashCode = 31 * hashCode + ((decisions() == null) ? 0 : decisions().hashCode());
        hashCode = 31 * hashCode + ((executionContext() == null) ? 0 : executionContext().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest) obj;
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.decisions() == null ^ this.decisions() == null) {
            return false;
        }
        if (other.decisions() != null && !other.decisions().equals(this.decisions())) {
            return false;
        }
        if (other.executionContext() == null ^ this.executionContext() == null) {
            return false;
        }
        if (other.executionContext() != null && !other.executionContext().equals(this.executionContext())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskToken() != null) {
            sb.append("TaskToken: ").append(taskToken()).append(",");
        }
        if (decisions() != null) {
            sb.append("Decisions: ").append(decisions()).append(",");
        }
        if (executionContext() != null) {
            sb.append("ExecutionContext: ").append(executionContext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> from the <a>DecisionTask</a>.
         * </p>
         * <important><code>taskToken</code> is generated by the service and should be treated as an opaque value. If
         * the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         * provide its progress and respond with results.</important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> from the <a>DecisionTask</a>.</p> <important><code>taskToken</code> is
         *        generated by the service and should be treated as an opaque value. If the task is passed to another
         *        process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
         *        respond with results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the decision structure for details.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the decision structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Collection<Decision> decisions);

        /**
         * <p>
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs
         * for the decision structure for details.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDecisions(java.util.Collection)} or {@link #withDecisions(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param decisions
         *        The list of decisions (possibly empty) made by the decider while processing this decision task. See
         *        the docs for the decision structure for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisions(Decision... decisions);

        /**
         * <p>
         * User defined context to add to workflow execution.
         * </p>
         * 
         * @param executionContext
         *        User defined context to add to workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionContext(String executionContext);
    }

    private static final class BuilderImpl implements Builder {
        private String taskToken;

        private List<Decision> decisions;

        private String executionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondDecisionTaskCompletedRequest model) {
            setTaskToken(model.taskToken);
            setDecisions(model.decisions);
            setExecutionContext(model.executionContext);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Collection<Decision> getDecisions() {
            return decisions;
        }

        @Override
        public final Builder decisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Decision... decisions) {
            if (this.decisions == null) {
                this.decisions = new ArrayList<>(decisions.length);
            }
            for (Decision e : decisions) {
                this.decisions.add(e);
            }
            return this;
        }

        public final void setDecisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
        }

        @SafeVarargs
        public final void setDecisions(Decision... decisions) {
            if (this.decisions == null) {
                this.decisions = new ArrayList<>(decisions.length);
            }
            for (Decision e : decisions) {
                this.decisions.add(e);
            }
        }

        public final String getExecutionContext() {
            return executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        @Override
        public RespondDecisionTaskCompletedRequest build() {
            return new RespondDecisionTaskCompletedRequest(this);
        }
    }
}
