/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RespondActivityTaskCompletedRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RespondActivityTaskCompletedRequest.Builder, RespondActivityTaskCompletedRequest> {
    private final String taskToken;

    private final String result;

    private RespondActivityTaskCompletedRequest(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.result = builder.result;
    }

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
     * task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</important>
     * 
     * @return The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important> <code>taskToken</code> is
     *         generated by the service and should be treated as an opaque value. If the task is passed to another
     *         process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
     *         respond with results.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The result of the activity task. It is a free form string that is implementation specific.
     * </p>
     * 
     * @return The result of the activity task. It is a free form string that is implementation specific.
     */
    public String result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskToken() == null) ? 0 : taskToken().hashCode());
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondActivityTaskCompletedRequest)) {
            return false;
        }
        RespondActivityTaskCompletedRequest other = (RespondActivityTaskCompletedRequest) obj;
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskToken() != null) {
            sb.append("TaskToken: ").append(taskToken()).append(",");
        }
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RespondActivityTaskCompletedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> of the <a>ActivityTask</a>.
         * </p>
         * <important> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If
         * the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         * provide its progress and respond with results.</important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important> <code>taskToken</code> is
         *        generated by the service and should be treated as an opaque value. If the task is passed to another
         *        process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
         *        respond with results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The result of the activity task. It is a free form string that is implementation specific.
         * </p>
         * 
         * @param result
         *        The result of the activity task. It is a free form string that is implementation specific.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);
    }

    private static final class BuilderImpl implements Builder {
        private String taskToken;

        private String result;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondActivityTaskCompletedRequest model) {
            setTaskToken(model.taskToken);
            setResult(model.result);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public RespondActivityTaskCompletedRequest build() {
            return new RespondActivityTaskCompletedRequest(this);
        }
    }
}
