/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.RequestCancelExternalWorkflowExecutionDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>RequestCancelExternalWorkflowExecution</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestCancelExternalWorkflowExecutionDecisionAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<RequestCancelExternalWorkflowExecutionDecisionAttributes.Builder, RequestCancelExternalWorkflowExecutionDecisionAttributes> {
    private final String workflowId;

    private final String runId;

    private final String control;

    private RequestCancelExternalWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.control = builder.control;
    }

    /**
     * <p>
     * <b>Required.</b> The <code>workflowId</code> of the external workflow execution to cancel.
     * </p>
     * 
     * @return Required.</b> The <code>workflowId
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the external workflow execution to cancel.
     * </p>
     * 
     * @return The <code>runId</code> of the external workflow execution to cancel.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCancelExternalWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        RequestCancelExternalWorkflowExecutionDecisionAttributes other = (RequestCancelExternalWorkflowExecutionDecisionAttributes) obj;
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RequestCancelExternalWorkflowExecutionDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RequestCancelExternalWorkflowExecutionDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The <code>workflowId</code> of the external workflow execution to cancel.
         * </p>
         * 
         * @param workflowId
         *        Required.</b> The <code>workflowId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the external workflow execution to cancel.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the external workflow execution to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    private static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCancelExternalWorkflowExecutionDecisionAttributes model) {
            setWorkflowId(model.workflowId);
            setRunId(model.runId);
            setControl(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public RequestCancelExternalWorkflowExecutionDecisionAttributes build() {
            return new RequestCancelExternalWorkflowExecutionDecisionAttributes(this);
        }
    }
}
