/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterWorkflowTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterWorkflowTypeRequest.Builder, RegisterWorkflowTypeRequest> {
    private final String domain;

    private final String name;

    private final String version;

    private final String description;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultExecutionStartToCloseTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultChildPolicy;

    private final String defaultLambdaRole;

    private RegisterWorkflowTypeRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    /**
     * <p>
     * The name of the domain in which to register the workflow type.
     * </p>
     * 
     * @return The name of the domain in which to register the workflow type.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the workflow type.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The name of the workflow type.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the workflow type.
     * </p>
     * <note>The workflow type consists of the name and version, the combination of which must be unique within the
     * domain. To get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a> action.</note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The version of the workflow type.</p> <note>The workflow type consists of the name and version, the
     *         combination of which must be unique within the domain. To get a list of all currently registered workflow
     *         types, use the <a>ListWorkflowTypes</a> action.</note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Textual description of the workflow type.
     * </p>
     * 
     * @return Textual description of the workflow type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be
     * overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     * <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration of decision tasks for this workflow type. This default can
     *         be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     *         <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration for executions of this workflow type. You can override this
     * default when starting an execution through the <a>StartWorkflowExecution</a> action or
     * <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout
     * parameters in Amazon SWF, you cannot specify a value of "NONE" for
     * <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow
     * execution can run. Exceeding this limit will always cause the workflow execution to time out.
     * </p>
     * 
     * @return If set, specifies the default maximum duration for executions of this workflow type. You can override
     *         this default when starting an execution through the <a>StartWorkflowExecution</a> action or
     *         <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other
     *         timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
     *         <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a
     *         workflow execution can run. Exceeding this limit will always cause the workflow execution to time out.
     */
    public String defaultExecutionStartToCloseTimeout() {
        return defaultExecutionStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow
     * type. This default is used only if a task list is not provided when starting the execution through the
     * <a>StartWorkflowExecution</a> action or <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * 
     * @return If set, specifies the default task list to use for scheduling decision tasks for executions of this
     *         workflow type. This default is used only if a task list is not provided when starting the execution
     *         through the <a>StartWorkflowExecution</a> action or <code>StartChildWorkflowExecution</code> decision.
     */
    public TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority to assign to the workflow type. If not assigned, then "0" will be used. Valid values
     * are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return The default task priority to assign to the workflow type. If not assigned, then "0" will be used. Valid
     *         values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     */
    public String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * If set, specifies the default policy to use for the child workflow executions when a workflow execution of this
     * type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     * timeout. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return If set, specifies the default policy to use for the child workflow executions when a workflow execution
     *         of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to
     *         an expired timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * @see ChildPolicy
     */
    public String defaultChildPolicy() {
        return defaultChildPolicy;
    }

    /**
     * <p>
     * The ARN of the default IAM role to use when a workflow execution of this type invokes AWS Lambda functions.
     * </p>
     * <p>
     * This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action
     * or the <code>StartChildWorkflowExecution</code> and <code>ContinueAsNewWorkflowExecution</code> decision.
     * </p>
     * 
     * @return The ARN of the default IAM role to use when a workflow execution of this type invokes AWS Lambda
     *         functions.</p>
     *         <p>
     *         This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
     *         action or the <code>StartChildWorkflowExecution</code> and <code>ContinueAsNewWorkflowExecution</code>
     *         decision.
     */
    public String defaultLambdaRole() {
        return defaultLambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskStartToCloseTimeout() == null) ? 0 : defaultTaskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode
                + ((defaultExecutionStartToCloseTimeout() == null) ? 0 : defaultExecutionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskList() == null) ? 0 : defaultTaskList().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskPriority() == null) ? 0 : defaultTaskPriority().hashCode());
        hashCode = 31 * hashCode + ((defaultChildPolicy() == null) ? 0 : defaultChildPolicy().hashCode());
        hashCode = 31 * hashCode + ((defaultLambdaRole() == null) ? 0 : defaultLambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkflowTypeRequest)) {
            return false;
        }
        RegisterWorkflowTypeRequest other = (RegisterWorkflowTypeRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() == null ^ this.defaultTaskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() != null
                && !other.defaultTaskStartToCloseTimeout().equals(this.defaultTaskStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultExecutionStartToCloseTimeout() == null ^ this.defaultExecutionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultExecutionStartToCloseTimeout() != null
                && !other.defaultExecutionStartToCloseTimeout().equals(this.defaultExecutionStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultTaskList() == null ^ this.defaultTaskList() == null) {
            return false;
        }
        if (other.defaultTaskList() != null && !other.defaultTaskList().equals(this.defaultTaskList())) {
            return false;
        }
        if (other.defaultTaskPriority() == null ^ this.defaultTaskPriority() == null) {
            return false;
        }
        if (other.defaultTaskPriority() != null && !other.defaultTaskPriority().equals(this.defaultTaskPriority())) {
            return false;
        }
        if (other.defaultChildPolicy() == null ^ this.defaultChildPolicy() == null) {
            return false;
        }
        if (other.defaultChildPolicy() != null && !other.defaultChildPolicy().equals(this.defaultChildPolicy())) {
            return false;
        }
        if (other.defaultLambdaRole() == null ^ this.defaultLambdaRole() == null) {
            return false;
        }
        if (other.defaultLambdaRole() != null && !other.defaultLambdaRole().equals(this.defaultLambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (defaultTaskStartToCloseTimeout() != null) {
            sb.append("DefaultTaskStartToCloseTimeout: ").append(defaultTaskStartToCloseTimeout()).append(",");
        }
        if (defaultExecutionStartToCloseTimeout() != null) {
            sb.append("DefaultExecutionStartToCloseTimeout: ").append(defaultExecutionStartToCloseTimeout()).append(",");
        }
        if (defaultTaskList() != null) {
            sb.append("DefaultTaskList: ").append(defaultTaskList()).append(",");
        }
        if (defaultTaskPriority() != null) {
            sb.append("DefaultTaskPriority: ").append(defaultTaskPriority()).append(",");
        }
        if (defaultChildPolicy() != null) {
            sb.append("DefaultChildPolicy: ").append(defaultChildPolicy()).append(",");
        }
        if (defaultLambdaRole() != null) {
            sb.append("DefaultLambdaRole: ").append(defaultLambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterWorkflowTypeRequest> {
        /**
         * <p>
         * The name of the domain in which to register the workflow type.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which to register the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the workflow type.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param name
         *        The name of the workflow type.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the workflow type.
         * </p>
         * <note>The workflow type consists of the name and version, the combination of which must be unique within the
         * domain. To get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a>
         * action.</note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param version
         *        The version of the workflow type.</p> <note>The workflow type consists of the name and version, the
         *        combination of which must be unique within the domain. To get a list of all currently registered
         *        workflow types, use the <a>ListWorkflowTypes</a> action.</note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Textual description of the workflow type.
         * </p>
         * 
         * @param description
         *        Textual description of the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be
         * overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
         * <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        If set, specifies the default maximum duration of decision tasks for this workflow type. This default
         *        can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or
         *        the <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default maximum duration for executions of this workflow type. You can override this
         * default when starting an execution through the <a>StartWorkflowExecution</a> action or
         * <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout
         * parameters in Amazon SWF, you cannot specify a value of "NONE" for
         * <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow
         * execution can run. Exceeding this limit will always cause the workflow execution to time out.
         * </p>
         * 
         * @param defaultExecutionStartToCloseTimeout
         *        If set, specifies the default maximum duration for executions of this workflow type. You can override
         *        this default when starting an execution through the <a>StartWorkflowExecution</a> action or
         *        <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other
         *        timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
         *        <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a
         *        workflow execution can run. Exceeding this limit will always cause the workflow execution to time out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow
         * type. This default is used only if a task list is not provided when starting the execution through the
         * <a>StartWorkflowExecution</a> action or <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * 
         * @param defaultTaskList
         *        If set, specifies the default task list to use for scheduling decision tasks for executions of this
         *        workflow type. This default is used only if a task list is not provided when starting the execution
         *        through the <a>StartWorkflowExecution</a> action or <code>StartChildWorkflowExecution</code> decision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * The default task priority to assign to the workflow type. If not assigned, then "0" will be used. Valid
         * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority to assign to the workflow type. If not assigned, then "0" will be used.
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * If set, specifies the default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        If set, specifies the default policy to use for the child workflow executions when a workflow
         *        execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This default can be overridden when starting a workflow
         *        execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(String defaultChildPolicy);

        /**
         * <p>
         * If set, specifies the default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        If set, specifies the default policy to use for the child workflow executions when a workflow
         *        execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This default can be overridden when starting a workflow
         *        execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(ChildPolicy defaultChildPolicy);

        /**
         * <p>
         * The ARN of the default IAM role to use when a workflow execution of this type invokes AWS Lambda functions.
         * </p>
         * <p>
         * This default can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a>
         * action or the <code>StartChildWorkflowExecution</code> and <code>ContinueAsNewWorkflowExecution</code>
         * decision.
         * </p>
         * 
         * @param defaultLambdaRole
         *        The ARN of the default IAM role to use when a workflow execution of this type invokes AWS Lambda
         *        functions.</p>
         *        <p>
         *        This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> and
         *        <code>ContinueAsNewWorkflowExecution</code> decision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultLambdaRole(String defaultLambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private String name;

        private String version;

        private String description;

        private String defaultTaskStartToCloseTimeout;

        private String defaultExecutionStartToCloseTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultChildPolicy;

        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkflowTypeRequest model) {
            setDomain(model.domain);
            setName(model.name);
            setVersion(model.version);
            setDescription(model.description);
            setDefaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            setDefaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            setDefaultTaskList(model.defaultTaskList);
            setDefaultTaskPriority(model.defaultTaskPriority);
            setDefaultChildPolicy(model.defaultChildPolicy);
            setDefaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        public final TaskList getDefaultTaskList() {
            return defaultTaskList;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultChildPolicy() {
            return defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy.toString());
            return this;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        public final void setDefaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy.toString());
        }

        public final String getDefaultLambdaRole() {
            return defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        @Override
        public RegisterWorkflowTypeRequest build() {
            return new RegisterWorkflowTypeRequest(this);
        }
    }
}
