/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterDomainRequest.Builder, RegisterDomainRequest> {
    private final String name;

    private final String description;

    private final String workflowExecutionRetentionPeriodInDays;

    private RegisterDomainRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.workflowExecutionRetentionPeriodInDays = builder.workflowExecutionRetentionPeriodInDays;
    }

    /**
     * <p>
     * Name of the domain to register. The name must be unique in the region that the domain is registered in.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Name of the domain to register. The name must be unique in the region that the domain is registered
     *         in.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A text description of the domain.
     * </p>
     * 
     * @return A text description of the domain.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
     * service. After the retention period, the workflow execution is not available in the results of visibility calls.
     * </p>
     * <p>
     * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history will not be
     * retained. As soon as the workflow execution completes, the execution record and its history are deleted.
     * </p>
     * <p>
     * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits,
     * see: <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     * Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The duration (in days) that records and histories of workflow executions on the domain should be kept by
     *         the service. After the retention period, the workflow execution is not available in the results of
     *         visibility calls.</p>
     *         <p>
     *         If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
     *         will not be retained. As soon as the workflow execution completes, the execution record and its history
     *         are deleted.
     *         </p>
     *         <p>
     *         The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
     *         limits, see: <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF Service
     *         Limits</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public String workflowExecutionRetentionPeriodInDays() {
        return workflowExecutionRetentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode
                + ((workflowExecutionRetentionPeriodInDays() == null) ? 0 : workflowExecutionRetentionPeriodInDays().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.workflowExecutionRetentionPeriodInDays() == null ^ this.workflowExecutionRetentionPeriodInDays() == null) {
            return false;
        }
        if (other.workflowExecutionRetentionPeriodInDays() != null
                && !other.workflowExecutionRetentionPeriodInDays().equals(this.workflowExecutionRetentionPeriodInDays())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (workflowExecutionRetentionPeriodInDays() != null) {
            sb.append("WorkflowExecutionRetentionPeriodInDays: ").append(workflowExecutionRetentionPeriodInDays()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterDomainRequest> {
        /**
         * <p>
         * Name of the domain to register. The name must be unique in the region that the domain is registered in.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param name
         *        Name of the domain to register. The name must be unique in the region that the domain is registered
         *        in.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A text description of the domain.
         * </p>
         * 
         * @param description
         *        A text description of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The duration (in days) that records and histories of workflow executions on the domain should be kept by the
         * service. After the retention period, the workflow execution is not available in the results of visibility
         * calls.
         * </p>
         * <p>
         * If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history will
         * not be retained. As soon as the workflow execution completes, the execution record and its history are
         * deleted.
         * </p>
         * <p>
         * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service
         * limits, see: <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon
         * SWF Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param workflowExecutionRetentionPeriodInDays
         *        The duration (in days) that records and histories of workflow executions on the domain should be kept
         *        by the service. After the retention period, the workflow execution is not available in the results of
         *        visibility calls.</p>
         *        <p>
         *        If you pass the value <code>NONE</code> or <code>0</code> (zero), then the workflow execution history
         *        will not be retained. As soon as the workflow execution completes, the execution record and its
         *        history are deleted.
         *        </p>
         *        <p>
         *        The maximum workflow execution retention period is 90 days. For more information about Amazon SWF
         *        service limits, see: <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html">Amazon SWF
         *        Service Limits</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String workflowExecutionRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            setName(model.name);
            setDescription(model.description);
            setWorkflowExecutionRetentionPeriodInDays(model.workflowExecutionRetentionPeriodInDays);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getWorkflowExecutionRetentionPeriodInDays() {
            return workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public final Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
            return this;
        }

        public final void setWorkflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }
    }
}
