/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.RecordMarkerFailedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>RecordMarkerFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordMarkerFailedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<RecordMarkerFailedEventAttributes.Builder, RecordMarkerFailedEventAttributes> {
    private final String markerName;

    private final String cause;

    private final Long decisionTaskCompletedEventId;

    private RecordMarkerFailedEventAttributes(BuilderImpl builder) {
        this.markerName = builder.markerName;
        this.cause = builder.cause;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The marker's name.
     * </p>
     * 
     * @return The marker's name.
     */
    public String markerName() {
        return markerName;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
     * permissions. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.</note>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a>.
     * @see RecordMarkerFailedCause
     */
    public String cause() {
        return cause;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((markerName() == null) ? 0 : markerName().hashCode());
        hashCode = 31 * hashCode + ((cause() == null) ? 0 : cause().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordMarkerFailedEventAttributes)) {
            return false;
        }
        RecordMarkerFailedEventAttributes other = (RecordMarkerFailedEventAttributes) obj;
        if (other.markerName() == null ^ this.markerName() == null) {
            return false;
        }
        if (other.markerName() != null && !other.markerName().equals(this.markerName())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (markerName() != null) {
            sb.append("MarkerName: ").append(markerName()).append(",");
        }
        if (cause() != null) {
            sb.append("Cause: ").append(cause()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarkerFailedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecordMarkerFailedEventAttributes> {
        /**
         * <p>
         * The marker's name.
         * </p>
         * 
         * @param markerName
         *        The marker's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerName(String markerName);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
         * permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a>.</note>
         * 
         * @param cause
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordMarkerFailedCause
         */
        Builder cause(String cause);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
         * permissions. For details and example IAM policies, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access
         * to Amazon SWF Workflows</a>.</note>
         * 
         * @param cause
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>If <b>cause</b> is set to OPERATION_NOT_PERMITTED, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         *        Access to Amazon SWF Workflows</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordMarkerFailedCause
         */
        Builder cause(RecordMarkerFailedCause cause);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>RecordMarkerFailed</code> decision for this cancellation request. This information can be useful
         * for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>RecordMarkerFailed</code> decision for this cancellation request. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String markerName;

        private String cause;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordMarkerFailedEventAttributes model) {
            setMarkerName(model.markerName);
            setCause(model.cause);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getMarkerName() {
            return markerName;
        }

        @Override
        public final Builder markerName(String markerName) {
            this.markerName = markerName;
            return this;
        }

        public final void setMarkerName(String markerName) {
            this.markerName = markerName;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(RecordMarkerFailedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final void setCause(RecordMarkerFailedCause cause) {
            this.cause(cause.toString());
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public RecordMarkerFailedEventAttributes build() {
            return new RecordMarkerFailedEventAttributes(this);
        }
    }
}
