/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a decision task. Decision tasks are sent to deciders in order for them to make decisions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PollForDecisionTaskResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PollForDecisionTaskResponse.Builder, PollForDecisionTaskResponse> {
    private final String taskToken;

    private final Long startedEventId;

    private final WorkflowExecution workflowExecution;

    private final WorkflowType workflowType;

    private final List<HistoryEvent> events;

    private final String nextPageToken;

    private final Long previousStartedEventId;

    private PollForDecisionTaskResponse(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
        this.previousStartedEventId = builder.previousStartedEventId;
    }

    /**
     * <p>
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     * response information back to the system about the task.
     * </p>
     * 
     * @return The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     *         response information back to the system about the task.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The workflow execution for which this decision task was created.
     * </p>
     * 
     * @return The workflow execution for which this decision task was created.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of the workflow execution for which this decision task was created.
     * </p>
     * 
     * @return The type of the workflow execution for which this decision task was created.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * A paginated list of history events of the workflow execution. The decider uses this during the processing of the
     * decision task.
     * </p>
     * 
     * @return A paginated list of history events of the workflow execution. The decider uses this during the processing
     *         of the decision task.
     */
    public List<HistoryEvent> events() {
        return events;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
     * processed by the decider. This can be used to determine the events in the history new since the last decision
     * task received by the decider.
     * </p>
     * 
     * @return The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
     *         processed by the decider. This can be used to determine the events in the history new since the last
     *         decision task received by the decider.
     */
    public Long previousStartedEventId() {
        return previousStartedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskToken() == null) ? 0 : taskToken().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        hashCode = 31 * hashCode + ((workflowExecution() == null) ? 0 : workflowExecution().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        hashCode = 31 * hashCode + ((previousStartedEventId() == null) ? 0 : previousStartedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskResponse)) {
            return false;
        }
        PollForDecisionTaskResponse other = (PollForDecisionTaskResponse) obj;
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.workflowExecution() == null ^ this.workflowExecution() == null) {
            return false;
        }
        if (other.workflowExecution() != null && !other.workflowExecution().equals(this.workflowExecution())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        if (other.previousStartedEventId() == null ^ this.previousStartedEventId() == null) {
            return false;
        }
        if (other.previousStartedEventId() != null && !other.previousStartedEventId().equals(this.previousStartedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskToken() != null) {
            sb.append("TaskToken: ").append(taskToken()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        if (workflowExecution() != null) {
            sb.append("WorkflowExecution: ").append(workflowExecution()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (previousStartedEventId() != null) {
            sb.append("PreviousStartedEventId: ").append(previousStartedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PollForDecisionTaskResponse> {
        /**
         * <p>
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
         * response information back to the system about the task.
         * </p>
         * 
         * @param taskToken
         *        The opaque string used as a handle on the task. This token is used by workers to communicate progress
         *        and response information back to the system about the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>DecisionTaskStarted</code> event recorded in the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The workflow execution for which this decision task was created.
         * </p>
         * 
         * @param workflowExecution
         *        The workflow execution for which this decision task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The type of the workflow execution for which this decision task was created.
         * </p>
         * 
         * @param workflowType
         *        The type of the workflow execution for which this decision task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of
         * the decision task.
         * </p>
         * 
         * @param events
         *        A paginated list of history events of the workflow execution. The decider uses this during the
         *        processing of the decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<HistoryEvent> events);

        /**
         * <p>
         * A paginated list of history events of the workflow execution. The decider uses this during the processing of
         * the decision task.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        A paginated list of history events of the workflow execution. The decider uses this during the
         *        processing of the decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(HistoryEvent... events);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that was
         * processed by the decider. This can be used to determine the events in the history new since the last decision
         * task received by the decider.
         * </p>
         * 
         * @param previousStartedEventId
         *        The ID of the DecisionTaskStarted event of the previous decision task of this workflow execution that
         *        was processed by the decider. This can be used to determine the events in the history new since the
         *        last decision task received by the decider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousStartedEventId(Long previousStartedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String taskToken;

        private Long startedEventId;

        private WorkflowExecution workflowExecution;

        private WorkflowType workflowType;

        private List<HistoryEvent> events;

        private String nextPageToken;

        private Long previousStartedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskResponse model) {
            setTaskToken(model.taskToken);
            setStartedEventId(model.startedEventId);
            setWorkflowExecution(model.workflowExecution);
            setWorkflowType(model.workflowType);
            setEvents(model.events);
            setNextPageToken(model.nextPageToken);
            setPreviousStartedEventId(model.previousStartedEventId);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final WorkflowExecution getWorkflowExecution() {
            return workflowExecution;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Collection<HistoryEvent> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(HistoryEvent... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Long getPreviousStartedEventId() {
            return previousStartedEventId;
        }

        @Override
        public final Builder previousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
            return this;
        }

        public final void setPreviousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
        }

        @Override
        public PollForDecisionTaskResponse build() {
            return new PollForDecisionTaskResponse(this);
        }
    }
}
