/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PollForDecisionTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PollForDecisionTaskRequest.Builder, PollForDecisionTaskRequest> {
    private final String domain;

    private final TaskList taskList;

    private final String identity;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private PollForDecisionTaskRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.taskList = builder.taskList;
        this.identity = builder.identity;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The name of the domain containing the task lists to poll.
     * </p>
     * 
     * @return The name of the domain containing the task lists to poll.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the task list to poll for decision tasks.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Specifies the task list to poll for decision tasks.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow
     * history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.
     * </p>
     * 
     * @return Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
     *         workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
     *         defined.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * <note>The <code>nextPageToken</code> returned by this action cannot be used with
     * <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with the
     * <code>nextPageToken</code>) to retrieve the next page of history records. Calling <a>PollForDecisionTask</a> with
     * a <code>nextPageToken</code> will not return a new decision task.</note>.
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     *         </p>
     *         <note>The <code>nextPageToken</code> returned by this action cannot be used with
     *         <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again
     *         (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling
     *         <a>PollForDecisionTask</a> with a <code>nextPageToken</code> will not return a new decision task.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to obtain
     * futher pages of results. The default is 1000, which is the maximum allowed page size. You can, however, specify a
     * page size <i>smaller</i> than the maximum.
     * </p>
     * <p>
     * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
     *         obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
     *         however, specify a page size <i>smaller</i> than the maximum.</p>
     *         <p>
     *         This is an upper limit only; the actual number of results returned per call may be fewer than the
     *         specified maximum.
     */
    public Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
     * ascending order of the <code>eventTimestamp</code> of the events.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the events in reverse order. By default the results are returned
     *         in ascending order of the <code>eventTimestamp</code> of the events.
     */
    public Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        hashCode = 31 * hashCode + ((maximumPageSize() == null) ? 0 : maximumPageSize().hashCode());
        hashCode = 31 * hashCode + ((reverseOrder() == null) ? 0 : reverseOrder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskRequest)) {
            return false;
        }
        PollForDecisionTaskRequest other = (PollForDecisionTaskRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        if (other.maximumPageSize() == null ^ this.maximumPageSize() == null) {
            return false;
        }
        if (other.maximumPageSize() != null && !other.maximumPageSize().equals(this.maximumPageSize())) {
            return false;
        }
        if (other.reverseOrder() == null ^ this.reverseOrder() == null) {
            return false;
        }
        if (other.reverseOrder() != null && !other.reverseOrder().equals(this.reverseOrder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (maximumPageSize() != null) {
            sb.append("MaximumPageSize: ").append(maximumPageSize()).append(",");
        }
        if (reverseOrder() != null) {
            sb.append("ReverseOrder: ").append(reverseOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PollForDecisionTaskRequest> {
        /**
         * <p>
         * The name of the domain containing the task lists to poll.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the task lists to poll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the task list to poll for decision tasks.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param taskList
         *        Specifies the task list to poll for decision tasks.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
         * workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
         * defined.
         * </p>
         * 
         * @param identity
         *        Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the
         *        workflow history. This enables diagnostic tracing when problems arise. The form of this identity is
         *        user defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * <note>The <code>nextPageToken</code> returned by this action cannot be used with
         * <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a> again (with
         * the <code>nextPageToken</code>) to retrieve the next page of history records. Calling
         * <a>PollForDecisionTask</a> with a <code>nextPageToken</code> will not return a new decision task.</note>.
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         *        </p>
         *        <note>The <code>nextPageToken</code> returned by this action cannot be used with
         *        <a>GetWorkflowExecutionHistory</a> to get the next page. You must call <a>PollForDecisionTask</a>
         *        again (with the <code>nextPageToken</code>) to retrieve the next page of history records. Calling
         *        <a>PollForDecisionTask</a> with a <code>nextPageToken</code> will not return a new decision task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
         * obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
         * however, specify a page size <i>smaller</i> than the maximum.
         * </p>
         * <p>
         * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
         * maximum.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used
         *        to obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You
         *        can, however, specify a page size <i>smaller</i> than the maximum.</p>
         *        <p>
         *        This is an upper limit only; the actual number of results returned per call may be fewer than the
         *        specified maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the events in reverse order. By default the results are returned in
         * ascending order of the <code>eventTimestamp</code> of the events.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the events in reverse order. By default the results are
         *        returned in ascending order of the <code>eventTimestamp</code> of the events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private TaskList taskList;

        private String identity;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskRequest model) {
            setDomain(model.domain);
            setTaskList(model.taskList);
            setIdentity(model.identity);
            setNextPageToken(model.nextPageToken);
            setMaximumPageSize(model.maximumPageSize);
            setReverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public PollForDecisionTaskRequest build() {
            return new PollForDecisionTaskRequest(this);
        }
    }
}
