/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated list of information about workflow executions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOpenWorkflowExecutionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOpenWorkflowExecutionsResponse.Builder, ListOpenWorkflowExecutionsResponse> {
    private final List<WorkflowExecutionInfo> executionInfos;

    private final String nextPageToken;

    private ListOpenWorkflowExecutionsResponse(BuilderImpl builder) {
        this.executionInfos = builder.executionInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The list of workflow information structures.
     * </p>
     * 
     * @return The list of workflow information structures.
     */
    public List<WorkflowExecutionInfo> executionInfos() {
        return executionInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((executionInfos() == null) ? 0 : executionInfos().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenWorkflowExecutionsResponse)) {
            return false;
        }
        ListOpenWorkflowExecutionsResponse other = (ListOpenWorkflowExecutionsResponse) obj;
        if (other.executionInfos() == null ^ this.executionInfos() == null) {
            return false;
        }
        if (other.executionInfos() != null && !other.executionInfos().equals(this.executionInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (executionInfos() != null) {
            sb.append("ExecutionInfos: ").append(executionInfos()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOpenWorkflowExecutionsResponse> {
        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos);

        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setExecutionInfos(java.util.Collection)} or {@link #withExecutionInfos(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(WorkflowExecutionInfo... executionInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<WorkflowExecutionInfo> executionInfos;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenWorkflowExecutionsResponse model) {
            setExecutionInfos(model.executionInfos);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowExecutionInfo> getExecutionInfos() {
            return executionInfos;
        }

        @Override
        public final Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(WorkflowExecutionInfo... executionInfos) {
            if (this.executionInfos == null) {
                this.executionInfos = new ArrayList<>(executionInfos.length);
            }
            for (WorkflowExecutionInfo e : executionInfos) {
                this.executionInfos.add(e);
            }
            return this;
        }

        public final void setExecutionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
        }

        @SafeVarargs
        public final void setExecutionInfos(WorkflowExecutionInfo... executionInfos) {
            if (this.executionInfos == null) {
                this.executionInfos = new ArrayList<>(executionInfos.length);
            }
            for (WorkflowExecutionInfo e : executionInfos) {
                this.executionInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListOpenWorkflowExecutionsResponse build() {
            return new ListOpenWorkflowExecutionsResponse(this);
        }
    }
}
