/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOpenWorkflowExecutionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListOpenWorkflowExecutionsRequest.Builder, ListOpenWorkflowExecutionsRequest> {
    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private final WorkflowExecutionFilter executionFilter;

    private ListOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
        this.executionFilter = builder.executionFilter;
    }

    /**
     * <p>
     * The name of the domain that contains the workflow executions to list.
     * </p>
     * 
     * @return The name of the domain that contains the workflow executions to list.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Workflow executions are included in the returned results based on whether their start times are within the range
     * specified by this filter.
     * </p>
     * 
     * @return Workflow executions are included in the returned results based on whether their start times are within
     *         the range specified by this filter.
     */
    public ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * If specified, only executions of the type specified in the filter are returned.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only executions of the type specified in the filter are returned.</p> <note>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     */
    public WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have the matching tag are listed.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only executions that have the matching tag are listed.</p> <note>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     */
    public TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to obtain
     * futher pages of results. The default is 1000, which is the maximum allowed page size. You can, however, specify a
     * page size <i>smaller</i> than the maximum.
     * </p>
     * <p>
     * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
     *         obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
     *         however, specify a page size <i>smaller</i> than the maximum.</p>
     *         <p>
     *         This is an upper limit only; the actual number of results returned per call may be fewer than the
     *         specified maximum.
     */
    public Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
     * descending order of the start time of the executions.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the results in reverse order. By default the results are returned
     *         in descending order of the start time of the executions.
     */
    public Boolean reverseOrder() {
        return reverseOrder;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p>
     *         <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
     *         exclusive. You can specify at most one of these in a request.
     */
    public WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((startTimeFilter() == null) ? 0 : startTimeFilter().hashCode());
        hashCode = 31 * hashCode + ((typeFilter() == null) ? 0 : typeFilter().hashCode());
        hashCode = 31 * hashCode + ((tagFilter() == null) ? 0 : tagFilter().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        hashCode = 31 * hashCode + ((maximumPageSize() == null) ? 0 : maximumPageSize().hashCode());
        hashCode = 31 * hashCode + ((reverseOrder() == null) ? 0 : reverseOrder().hashCode());
        hashCode = 31 * hashCode + ((executionFilter() == null) ? 0 : executionFilter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenWorkflowExecutionsRequest)) {
            return false;
        }
        ListOpenWorkflowExecutionsRequest other = (ListOpenWorkflowExecutionsRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.startTimeFilter() == null ^ this.startTimeFilter() == null) {
            return false;
        }
        if (other.startTimeFilter() != null && !other.startTimeFilter().equals(this.startTimeFilter())) {
            return false;
        }
        if (other.typeFilter() == null ^ this.typeFilter() == null) {
            return false;
        }
        if (other.typeFilter() != null && !other.typeFilter().equals(this.typeFilter())) {
            return false;
        }
        if (other.tagFilter() == null ^ this.tagFilter() == null) {
            return false;
        }
        if (other.tagFilter() != null && !other.tagFilter().equals(this.tagFilter())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        if (other.maximumPageSize() == null ^ this.maximumPageSize() == null) {
            return false;
        }
        if (other.maximumPageSize() != null && !other.maximumPageSize().equals(this.maximumPageSize())) {
            return false;
        }
        if (other.reverseOrder() == null ^ this.reverseOrder() == null) {
            return false;
        }
        if (other.reverseOrder() != null && !other.reverseOrder().equals(this.reverseOrder())) {
            return false;
        }
        if (other.executionFilter() == null ^ this.executionFilter() == null) {
            return false;
        }
        if (other.executionFilter() != null && !other.executionFilter().equals(this.executionFilter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (startTimeFilter() != null) {
            sb.append("StartTimeFilter: ").append(startTimeFilter()).append(",");
        }
        if (typeFilter() != null) {
            sb.append("TypeFilter: ").append(typeFilter()).append(",");
        }
        if (tagFilter() != null) {
            sb.append("TagFilter: ").append(tagFilter()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (maximumPageSize() != null) {
            sb.append("MaximumPageSize: ").append(maximumPageSize()).append(",");
        }
        if (reverseOrder() != null) {
            sb.append("ReverseOrder: ").append(reverseOrder()).append(",");
        }
        if (executionFilter() != null) {
            sb.append("ExecutionFilter: ").append(executionFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOpenWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain that contains the workflow executions to list.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the workflow executions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Workflow executions are included in the returned results based on whether their start times are within the
         * range specified by this filter.
         * </p>
         * 
         * @param startTimeFilter
         *        Workflow executions are included in the returned results based on whether their start times are within
         *        the range specified by this filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * If specified, only executions of the type specified in the filter are returned.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param typeFilter
         *        If specified, only executions of the type specified in the filter are returned.</p> <note>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, only executions that have the matching tag are listed.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param tagFilter
         *        If specified, only executions that have the matching tag are listed.</p> <note>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
         * obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
         * however, specify a page size <i>smaller</i> than the maximum.
         * </p>
         * <p>
         * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
         * maximum.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used
         *        to obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You
         *        can, however, specify a page size <i>smaller</i> than the maximum.</p>
         *        <p>
         *        This is an upper limit only; the actual number of results returned per call may be fewer than the
         *        specified maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
         * descending order of the start time of the executions.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the results in reverse order. By default the results are
         *        returned in descending order of the start time of the executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        /**
         * <p>
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the workflow ID specified in the filter are
         *        returned.</p> <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
         *        are mutually exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenWorkflowExecutionsRequest model) {
            setDomain(model.domain);
            setStartTimeFilter(model.startTimeFilter);
            setTypeFilter(model.typeFilter);
            setTagFilter(model.tagFilter);
            setNextPageToken(model.nextPageToken);
            setMaximumPageSize(model.maximumPageSize);
            setReverseOrder(model.reverseOrder);
            setExecutionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter getStartTimeFilter() {
            return startTimeFilter;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
        }

        public final WorkflowTypeFilter getTypeFilter() {
            return typeFilter;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
        }

        public final TagFilter getTagFilter() {
            return tagFilter;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        public final WorkflowExecutionFilter getExecutionFilter() {
            return executionFilter;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        @Override
        public ListOpenWorkflowExecutionsRequest build() {
            return new ListOpenWorkflowExecutionsRequest(this);
        }
    }
}
