/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDomainsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDomainsRequest.Builder, ListDomainsRequest> {
    private final String nextPageToken;

    private final String registrationStatus;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private ListDomainsRequest(BuilderImpl builder) {
        this.nextPageToken = builder.nextPageToken;
        this.registrationStatus = builder.registrationStatus;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * Specifies the registration status of the domains to list.
     * </p>
     * 
     * @return Specifies the registration status of the domains to list.
     * @see RegistrationStatus
     */
    public String registrationStatus() {
        return registrationStatus;
    }

    /**
     * <p>
     * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to obtain
     * futher pages of results. The default is 1000, which is the maximum allowed page size. You can, however, specify a
     * page size <i>smaller</i> than the maximum.
     * </p>
     * <p>
     * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
     *         obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
     *         however, specify a page size <i>smaller</i> than the maximum.</p>
     *         <p>
     *         This is an upper limit only; the actual number of results returned per call may be fewer than the
     *         specified maximum.
     */
    public Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in
     * ascending alphabetical order by <code>name</code> of the domains.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the results in reverse order. By default, the results are returned
     *         in ascending alphabetical order by <code>name</code> of the domains.
     */
    public Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        hashCode = 31 * hashCode + ((registrationStatus() == null) ? 0 : registrationStatus().hashCode());
        hashCode = 31 * hashCode + ((maximumPageSize() == null) ? 0 : maximumPageSize().hashCode());
        hashCode = 31 * hashCode + ((reverseOrder() == null) ? 0 : reverseOrder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest) obj;
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        if (other.registrationStatus() == null ^ this.registrationStatus() == null) {
            return false;
        }
        if (other.registrationStatus() != null && !other.registrationStatus().equals(this.registrationStatus())) {
            return false;
        }
        if (other.maximumPageSize() == null ^ this.maximumPageSize() == null) {
            return false;
        }
        if (other.maximumPageSize() != null && !other.maximumPageSize().equals(this.maximumPageSize())) {
            return false;
        }
        if (other.reverseOrder() == null ^ this.reverseOrder() == null) {
            return false;
        }
        if (other.reverseOrder() != null && !other.reverseOrder().equals(this.reverseOrder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (registrationStatus() != null) {
            sb.append("RegistrationStatus: ").append(registrationStatus()).append(",");
        }
        if (maximumPageSize() != null) {
            sb.append("MaximumPageSize: ").append(maximumPageSize()).append(",");
        }
        if (reverseOrder() != null) {
            sb.append("ReverseOrder: ").append(reverseOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDomainsRequest> {
        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * Specifies the registration status of the domains to list.
         * </p>
         * 
         * @param registrationStatus
         *        Specifies the registration status of the domains to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * Specifies the registration status of the domains to list.
         * </p>
         * 
         * @param registrationStatus
         *        Specifies the registration status of the domains to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used to
         * obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You can,
         * however, specify a page size <i>smaller</i> than the maximum.
         * </p>
         * <p>
         * This is an upper limit only; the actual number of results returned per call may be fewer than the specified
         * maximum.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that will be returned per call. <code>nextPageToken</code> can be used
         *        to obtain futher pages of results. The default is 1000, which is the maximum allowed page size. You
         *        can, however, specify a page size <i>smaller</i> than the maximum.</p>
         *        <p>
         *        This is an upper limit only; the actual number of results returned per call may be fewer than the
         *        specified maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the results in reverse order. By default, the results are returned in
         * ascending alphabetical order by <code>name</code> of the domains.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the results in reverse order. By default, the results are
         *        returned in ascending alphabetical order by <code>name</code> of the domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);
    }

    private static final class BuilderImpl implements Builder {
        private String nextPageToken;

        private String registrationStatus;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsRequest model) {
            setNextPageToken(model.nextPageToken);
            setRegistrationStatus(model.registrationStatus);
            setMaximumPageSize(model.maximumPageSize);
            setReverseOrder(model.reverseOrder);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
            return this;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        public final void setRegistrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public ListDomainsRequest build() {
            return new ListDomainsRequest(this);
        }
    }
}
