/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated list of activity type information structures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListActivityTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListActivityTypesResponse.Builder, ListActivityTypesResponse> {
    private final List<ActivityTypeInfo> typeInfos;

    private final String nextPageToken;

    private ListActivityTypesResponse(BuilderImpl builder) {
        this.typeInfos = builder.typeInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * List of activity type information.
     * </p>
     * 
     * @return List of activity type information.
     */
    public List<ActivityTypeInfo> typeInfos() {
        return typeInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeInfos() == null) ? 0 : typeInfos().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivityTypesResponse)) {
            return false;
        }
        ListActivityTypesResponse other = (ListActivityTypesResponse) obj;
        if (other.typeInfos() == null ^ this.typeInfos() == null) {
            return false;
        }
        if (other.typeInfos() != null && !other.typeInfos().equals(this.typeInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (typeInfos() != null) {
            sb.append("TypeInfos: ").append(typeInfos()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListActivityTypesResponse> {
        /**
         * <p>
         * List of activity type information.
         * </p>
         * 
         * @param typeInfos
         *        List of activity type information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfos(Collection<ActivityTypeInfo> typeInfos);

        /**
         * <p>
         * List of activity type information.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTypeInfos(java.util.Collection)} or {@link #withTypeInfos(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param typeInfos
         *        List of activity type information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfos(ActivityTypeInfo... typeInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ActivityTypeInfo> typeInfos;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivityTypesResponse model) {
            setTypeInfos(model.typeInfos);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<ActivityTypeInfo> getTypeInfos() {
            return typeInfos;
        }

        @Override
        public final Builder typeInfos(Collection<ActivityTypeInfo> typeInfos) {
            this.typeInfos = ActivityTypeInfoListCopier.copy(typeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(ActivityTypeInfo... typeInfos) {
            if (this.typeInfos == null) {
                this.typeInfos = new ArrayList<>(typeInfos.length);
            }
            for (ActivityTypeInfo e : typeInfos) {
                this.typeInfos.add(e);
            }
            return this;
        }

        public final void setTypeInfos(Collection<ActivityTypeInfo> typeInfos) {
            this.typeInfos = ActivityTypeInfoListCopier.copy(typeInfos);
        }

        @SafeVarargs
        public final void setTypeInfos(ActivityTypeInfo... typeInfos) {
            if (this.typeInfos == null) {
                this.typeInfos = new ArrayList<>(typeInfos.length);
            }
            for (ActivityTypeInfo e : typeInfos) {
                this.typeInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListActivityTypesResponse build() {
            return new ListActivityTypesResponse(this);
        }
    }
}
