/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.LambdaFunctionScheduledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details for the <code>LambdaFunctionScheduled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaFunctionScheduledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<LambdaFunctionScheduledEventAttributes.Builder, LambdaFunctionScheduledEventAttributes> {
    private final String id;

    private final String name;

    private final String input;

    private final String startToCloseTimeout;

    private final Long decisionTaskCompletedEventId;

    private LambdaFunctionScheduledEventAttributes(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.input = builder.input;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique Amazon SWF ID for the AWS Lambda task.
     * </p>
     * 
     * @return The unique Amazon SWF ID for the AWS Lambda task.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the scheduled AWS Lambda function.
     * </p>
     * 
     * @return The name of the scheduled AWS Lambda function.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Input provided to the AWS Lambda function.
     * </p>
     * 
     * @return Input provided to the AWS Lambda function.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The maximum time, in seconds, that the AWS Lambda function can take to execute from start to close before it is
     * marked as failed.
     * </p>
     * 
     * @return The maximum time, in seconds, that the AWS Lambda function can take to execute from start to close before
     *         it is marked as failed.
     */
    public String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event for the decision that resulted in the scheduling of this
     * AWS Lambda function. This information can be useful for diagnosing problems by tracing back the chain of events
     * leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event for the decision that resulted in the scheduling
     *         of this AWS Lambda function. This information can be useful for diagnosing problems by tracing back the
     *         chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((startToCloseTimeout() == null) ? 0 : startToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionScheduledEventAttributes)) {
            return false;
        }
        LambdaFunctionScheduledEventAttributes other = (LambdaFunctionScheduledEventAttributes) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        if (other.startToCloseTimeout() != null && !other.startToCloseTimeout().equals(this.startToCloseTimeout())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(startToCloseTimeout()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionScheduledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionScheduledEventAttributes> {
        /**
         * <p>
         * The unique Amazon SWF ID for the AWS Lambda task.
         * </p>
         * 
         * @param id
         *        The unique Amazon SWF ID for the AWS Lambda task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the scheduled AWS Lambda function.
         * </p>
         * 
         * @param name
         *        The name of the scheduled AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Input provided to the AWS Lambda function.
         * </p>
         * 
         * @param input
         *        Input provided to the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The maximum time, in seconds, that the AWS Lambda function can take to execute from start to close before it
         * is marked as failed.
         * </p>
         * 
         * @param startToCloseTimeout
         *        The maximum time, in seconds, that the AWS Lambda function can take to execute from start to close
         *        before it is marked as failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event for the decision that resulted in the scheduling of
         * this AWS Lambda function. This information can be useful for diagnosing problems by tracing back the chain of
         * events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event for the decision that resulted in the
         *        scheduling of this AWS Lambda function. This information can be useful for diagnosing problems by
         *        tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String input;

        private String startToCloseTimeout;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionScheduledEventAttributes model) {
            setId(model.id);
            setName(model.name);
            setInput(model.input);
            setStartToCloseTimeout(model.startToCloseTimeout);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public LambdaFunctionScheduledEventAttributes build() {
            return new LambdaFunctionScheduledEventAttributes(this);
        }
    }
}
