/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.LambdaFunctionCompletedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details for the <code>LambdaFunctionCompleted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaFunctionCompletedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<LambdaFunctionCompletedEventAttributes.Builder, LambdaFunctionCompletedEventAttributes> {
    private final Long scheduledEventId;

    private final Long startedEventId;

    private final String result;

    private LambdaFunctionCompletedEventAttributes(BuilderImpl builder) {
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
        this.result = builder.result;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this AWS Lambda function was
     * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading up
     * to this event.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this AWS Lambda function
     *         was scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>LambdaFunctionStarted</code> event recorded in the history.
     * </p>
     * 
     * @return The ID of the <code>LambdaFunctionStarted</code> event recorded in the history.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The result of the function execution (if any).
     * </p>
     * 
     * @return The result of the function execution (if any).
     */
    public String result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((scheduledEventId() == null) ? 0 : scheduledEventId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionCompletedEventAttributes)) {
            return false;
        }
        LambdaFunctionCompletedEventAttributes other = (LambdaFunctionCompletedEventAttributes) obj;
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(scheduledEventId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionCompletedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionCompletedEventAttributes> {
        /**
         * <p>
         * The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this AWS Lambda function was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>LambdaFunctionScheduled</code> event that was recorded when this AWS Lambda
         *        function was scheduled. This information can be useful for diagnosing problems by tracing back the
         *        chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>LambdaFunctionStarted</code> event recorded in the history.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>LambdaFunctionStarted</code> event recorded in the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The result of the function execution (if any).
         * </p>
         * 
         * @param result
         *        The result of the function execution (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);
    }

    private static final class BuilderImpl implements Builder {
        private Long scheduledEventId;

        private Long startedEventId;

        private String result;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionCompletedEventAttributes model) {
            setScheduledEventId(model.scheduledEventId);
            setStartedEventId(model.startedEventId);
            setResult(model.result);
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public LambdaFunctionCompletedEventAttributes build() {
            return new LambdaFunctionCompletedEventAttributes(this);
        }
    }
}
