/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ExternalWorkflowExecutionCancelRequestedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ExternalWorkflowExecutionCancelRequested</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExternalWorkflowExecutionCancelRequestedEventAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder, ExternalWorkflowExecutionCancelRequestedEventAttributes> {
    private final WorkflowExecution workflowExecution;

    private final Long initiatedEventId;

    private ExternalWorkflowExecutionCancelRequestedEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.initiatedEventId = builder.initiatedEventId;
    }

    /**
     * <p>
     * The external workflow execution to which the cancellation request was delivered.
     * </p>
     * 
     * @return The external workflow execution to which the cancellation request was delivered.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution.
     *         This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     *         this event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowExecution() == null) ? 0 : workflowExecution().hashCode());
        hashCode = 31 * hashCode + ((initiatedEventId() == null) ? 0 : initiatedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalWorkflowExecutionCancelRequestedEventAttributes)) {
            return false;
        }
        ExternalWorkflowExecutionCancelRequestedEventAttributes other = (ExternalWorkflowExecutionCancelRequestedEventAttributes) obj;
        if (other.workflowExecution() == null ^ this.workflowExecution() == null) {
            return false;
        }
        if (other.workflowExecution() != null && !other.workflowExecution().equals(this.workflowExecution())) {
            return false;
        }
        if (other.initiatedEventId() == null ^ this.initiatedEventId() == null) {
            return false;
        }
        if (other.initiatedEventId() != null && !other.initiatedEventId().equals(this.initiatedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowExecution() != null) {
            sb.append("WorkflowExecution: ").append(workflowExecution()).append(",");
        }
        if (initiatedEventId() != null) {
            sb.append("InitiatedEventId: ").append(initiatedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalWorkflowExecutionCancelRequestedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExternalWorkflowExecutionCancelRequestedEventAttributes> {
        /**
         * <p>
         * The external workflow execution to which the cancellation request was delivered.
         * </p>
         * 
         * @param workflowExecution
         *        The external workflow execution to which the cancellation request was delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow execution. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this external workflow
         *        execution. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowExecution workflowExecution;

        private Long initiatedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalWorkflowExecutionCancelRequestedEventAttributes model) {
            setWorkflowExecution(model.workflowExecution);
            setInitiatedEventId(model.initiatedEventId);
        }

        public final WorkflowExecution getWorkflowExecution() {
            return workflowExecution;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        @Override
        public ExternalWorkflowExecutionCancelRequestedEventAttributes build() {
            return new ExternalWorkflowExecutionCancelRequestedEventAttributes(this);
        }
    }
}
