/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum EventType {
    WorkflowExecutionStarted("WorkflowExecutionStarted"),

    WorkflowExecutionCancelRequested("WorkflowExecutionCancelRequested"),

    WorkflowExecutionCompleted("WorkflowExecutionCompleted"),

    CompleteWorkflowExecutionFailed("CompleteWorkflowExecutionFailed"),

    WorkflowExecutionFailed("WorkflowExecutionFailed"),

    FailWorkflowExecutionFailed("FailWorkflowExecutionFailed"),

    WorkflowExecutionTimedOut("WorkflowExecutionTimedOut"),

    WorkflowExecutionCanceled("WorkflowExecutionCanceled"),

    CancelWorkflowExecutionFailed("CancelWorkflowExecutionFailed"),

    WorkflowExecutionContinuedAsNew("WorkflowExecutionContinuedAsNew"),

    ContinueAsNewWorkflowExecutionFailed("ContinueAsNewWorkflowExecutionFailed"),

    WorkflowExecutionTerminated("WorkflowExecutionTerminated"),

    DecisionTaskScheduled("DecisionTaskScheduled"),

    DecisionTaskStarted("DecisionTaskStarted"),

    DecisionTaskCompleted("DecisionTaskCompleted"),

    DecisionTaskTimedOut("DecisionTaskTimedOut"),

    ActivityTaskScheduled("ActivityTaskScheduled"),

    ScheduleActivityTaskFailed("ScheduleActivityTaskFailed"),

    ActivityTaskStarted("ActivityTaskStarted"),

    ActivityTaskCompleted("ActivityTaskCompleted"),

    ActivityTaskFailed("ActivityTaskFailed"),

    ActivityTaskTimedOut("ActivityTaskTimedOut"),

    ActivityTaskCanceled("ActivityTaskCanceled"),

    ActivityTaskCancelRequested("ActivityTaskCancelRequested"),

    RequestCancelActivityTaskFailed("RequestCancelActivityTaskFailed"),

    WorkflowExecutionSignaled("WorkflowExecutionSignaled"),

    MarkerRecorded("MarkerRecorded"),

    RecordMarkerFailed("RecordMarkerFailed"),

    TimerStarted("TimerStarted"),

    StartTimerFailed("StartTimerFailed"),

    TimerFired("TimerFired"),

    TimerCanceled("TimerCanceled"),

    CancelTimerFailed("CancelTimerFailed"),

    StartChildWorkflowExecutionInitiated("StartChildWorkflowExecutionInitiated"),

    StartChildWorkflowExecutionFailed("StartChildWorkflowExecutionFailed"),

    ChildWorkflowExecutionStarted("ChildWorkflowExecutionStarted"),

    ChildWorkflowExecutionCompleted("ChildWorkflowExecutionCompleted"),

    ChildWorkflowExecutionFailed("ChildWorkflowExecutionFailed"),

    ChildWorkflowExecutionTimedOut("ChildWorkflowExecutionTimedOut"),

    ChildWorkflowExecutionCanceled("ChildWorkflowExecutionCanceled"),

    ChildWorkflowExecutionTerminated("ChildWorkflowExecutionTerminated"),

    SignalExternalWorkflowExecutionInitiated("SignalExternalWorkflowExecutionInitiated"),

    SignalExternalWorkflowExecutionFailed("SignalExternalWorkflowExecutionFailed"),

    ExternalWorkflowExecutionSignaled("ExternalWorkflowExecutionSignaled"),

    RequestCancelExternalWorkflowExecutionInitiated("RequestCancelExternalWorkflowExecutionInitiated"),

    RequestCancelExternalWorkflowExecutionFailed("RequestCancelExternalWorkflowExecutionFailed"),

    ExternalWorkflowExecutionCancelRequested("ExternalWorkflowExecutionCancelRequested"),

    LambdaFunctionScheduled("LambdaFunctionScheduled"),

    LambdaFunctionStarted("LambdaFunctionStarted"),

    LambdaFunctionCompleted("LambdaFunctionCompleted"),

    LambdaFunctionFailed("LambdaFunctionFailed"),

    LambdaFunctionTimedOut("LambdaFunctionTimedOut"),

    ScheduleLambdaFunctionFailed("ScheduleLambdaFunctionFailed"),

    StartLambdaFunctionFailed("StartLambdaFunctionFailed");

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return EventType corresponding to the value
     */
    public static EventType fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
