/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.DomainInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains general information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainInfo implements StructuredPojo, ToCopyableBuilder<DomainInfo.Builder, DomainInfo> {
    private final String name;

    private final String status;

    private final String description;

    private DomainInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the domain. This name is unique within the account.
     * </p>
     * 
     * @return The name of the domain. This name is unique within the account.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the domain:
     * </p>
     * <ul>
     * <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for registering
     * types and creating new workflow executions.</li>
     * <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You should
     * not create new workflow executions in this domain.</li>
     * </ul>
     * 
     * @return The status of the domain:</p>
     *         <ul>
     *         <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for
     *         registering types and creating new workflow executions.</li>
     *         <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
     *         should not create new workflow executions in this domain.</li>
     * @see RegistrationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The description of the domain provided through <a>RegisterDomain</a>.
     * </p>
     * 
     * @return The description of the domain provided through <a>RegisterDomain</a>.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInfo)) {
            return false;
        }
        DomainInfo other = (DomainInfo) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainInfo> {
        /**
         * <p>
         * The name of the domain. This name is unique within the account.
         * </p>
         * 
         * @param name
         *        The name of the domain. This name is unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.</li>
         * <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.</li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.</li>
         *        <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.</li>
         * <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.</li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li><b>REGISTERED</b>: The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.</li>
         *        <li><b>DEPRECATED</b>: The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the domain provided through <a>RegisterDomain</a>.
         * </p>
         * 
         * @param description
         *        The description of the domain provided through <a>RegisterDomain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInfo model) {
            setName(model.name);
            setStatus(model.status);
            setDescription(model.description);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(RegistrationStatus status) {
            this.status(status.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public DomainInfo build() {
            return new DomainInfo(this);
        }
    }
}
