/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.DomainConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration settings of a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainConfiguration implements StructuredPojo, ToCopyableBuilder<DomainConfiguration.Builder, DomainConfiguration> {
    private final String workflowExecutionRetentionPeriodInDays;

    private DomainConfiguration(BuilderImpl builder) {
        this.workflowExecutionRetentionPeriodInDays = builder.workflowExecutionRetentionPeriodInDays;
    }

    /**
     * <p>
     * The retention period for workflow executions in this domain.
     * </p>
     * 
     * @return The retention period for workflow executions in this domain.
     */
    public String workflowExecutionRetentionPeriodInDays() {
        return workflowExecutionRetentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((workflowExecutionRetentionPeriodInDays() == null) ? 0 : workflowExecutionRetentionPeriodInDays().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainConfiguration)) {
            return false;
        }
        DomainConfiguration other = (DomainConfiguration) obj;
        if (other.workflowExecutionRetentionPeriodInDays() == null ^ this.workflowExecutionRetentionPeriodInDays() == null) {
            return false;
        }
        if (other.workflowExecutionRetentionPeriodInDays() != null
                && !other.workflowExecutionRetentionPeriodInDays().equals(this.workflowExecutionRetentionPeriodInDays())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowExecutionRetentionPeriodInDays() != null) {
            sb.append("WorkflowExecutionRetentionPeriodInDays: ").append(workflowExecutionRetentionPeriodInDays()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainConfiguration> {
        /**
         * <p>
         * The retention period for workflow executions in this domain.
         * </p>
         * 
         * @param workflowExecutionRetentionPeriodInDays
         *        The retention period for workflow executions in this domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays);
    }

    private static final class BuilderImpl implements Builder {
        private String workflowExecutionRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainConfiguration model) {
            setWorkflowExecutionRetentionPeriodInDays(model.workflowExecutionRetentionPeriodInDays);
        }

        public final String getWorkflowExecutionRetentionPeriodInDays() {
            return workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public final Builder workflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
            return this;
        }

        public final void setWorkflowExecutionRetentionPeriodInDays(String workflowExecutionRetentionPeriodInDays) {
            this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
        }

        @Override
        public DomainConfiguration build() {
            return new DomainConfiguration(this);
        }
    }
}
