/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeWorkflowTypeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeWorkflowTypeResponse.Builder, DescribeWorkflowTypeResponse> {
    private final WorkflowTypeInfo typeInfo;

    private final WorkflowTypeConfiguration configuration;

    private DescribeWorkflowTypeResponse(BuilderImpl builder) {
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * General information about the workflow type.
     * </p>
     * <p>
     * The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
     * </p>
     * <ul>
     * <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be running.</li>
     * <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use. You
     * should keep workers supporting this type running. You cannot create new workflow executions of this type.</li>
     * </ul>
     * 
     * @return General information about the workflow type.</p>
     *         <p>
     *         The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
     *         </p>
     *         <ul>
     *         <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be
     *         running.</li>
     *         <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use.
     *         You should keep workers supporting this type running. You cannot create new workflow executions of this
     *         type.</li>
     */
    public WorkflowTypeInfo typeInfo() {
        return typeInfo;
    }

    /**
     * <p>
     * Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
     * </p>
     * 
     * @return Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
     */
    public WorkflowTypeConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeInfo() == null) ? 0 : typeInfo().hashCode());
        hashCode = 31 * hashCode + ((configuration() == null) ? 0 : configuration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowTypeResponse)) {
            return false;
        }
        DescribeWorkflowTypeResponse other = (DescribeWorkflowTypeResponse) obj;
        if (other.typeInfo() == null ^ this.typeInfo() == null) {
            return false;
        }
        if (other.typeInfo() != null && !other.typeInfo().equals(this.typeInfo())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (typeInfo() != null) {
            sb.append("TypeInfo: ").append(typeInfo()).append(",");
        }
        if (configuration() != null) {
            sb.append("Configuration: ").append(configuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeWorkflowTypeResponse> {
        /**
         * <p>
         * General information about the workflow type.
         * </p>
         * <p>
         * The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be running.</li>
         * <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in use. You
         * should keep workers supporting this type running. You cannot create new workflow executions of this type.</li>
         * </ul>
         * 
         * @param typeInfo
         *        General information about the workflow type.</p>
         *        <p>
         *        The status of the workflow type (returned in the WorkflowTypeInfo structure) can be one of the
         *        following.
         *        </p>
         *        <ul>
         *        <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be
         *        running.</li>
         *        <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateWorkflowType</a>, but is still in
         *        use. You should keep workers supporting this type running. You cannot create new workflow executions
         *        of this type.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfo(WorkflowTypeInfo typeInfo);

        /**
         * <p>
         * Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
         * </p>
         * 
         * @param configuration
         *        Configuration settings of the workflow type registered through <a>RegisterWorkflowType</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(WorkflowTypeConfiguration configuration);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowTypeInfo typeInfo;

        private WorkflowTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowTypeResponse model) {
            setTypeInfo(model.typeInfo);
            setConfiguration(model.configuration);
        }

        public final WorkflowTypeInfo getTypeInfo() {
            return typeInfo;
        }

        @Override
        public final Builder typeInfo(WorkflowTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final void setTypeInfo(WorkflowTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        public final WorkflowTypeConfiguration getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(WorkflowTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(WorkflowTypeConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public DescribeWorkflowTypeResponse build() {
            return new DescribeWorkflowTypeResponse(this);
        }
    }
}
