/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeActivityTypeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeActivityTypeResponse.Builder, DescribeActivityTypeResponse> {
    private final ActivityTypeInfo typeInfo;

    private final ActivityTypeConfiguration configuration;

    private DescribeActivityTypeResponse(BuilderImpl builder) {
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * General information about the activity type.
     * </p>
     * <p>
     * The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
     * </p>
     * <ul>
     * <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be running.</li>
     * <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateActivityType</a>, but is still in use. You
     * should keep workers supporting this type running. You cannot create new tasks of this type.</li>
     * </ul>
     * 
     * @return General information about the activity type.</p>
     *         <p>
     *         The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
     *         </p>
     *         <ul>
     *         <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be
     *         running.</li>
     *         <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateActivityType</a>, but is still in use.
     *         You should keep workers supporting this type running. You cannot create new tasks of this type.</li>
     */
    public ActivityTypeInfo typeInfo() {
        return typeInfo;
    }

    /**
     * <p>
     * The configuration settings registered with the activity type.
     * </p>
     * 
     * @return The configuration settings registered with the activity type.
     */
    public ActivityTypeConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeInfo() == null) ? 0 : typeInfo().hashCode());
        hashCode = 31 * hashCode + ((configuration() == null) ? 0 : configuration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivityTypeResponse)) {
            return false;
        }
        DescribeActivityTypeResponse other = (DescribeActivityTypeResponse) obj;
        if (other.typeInfo() == null ^ this.typeInfo() == null) {
            return false;
        }
        if (other.typeInfo() != null && !other.typeInfo().equals(this.typeInfo())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (typeInfo() != null) {
            sb.append("TypeInfo: ").append(typeInfo()).append(",");
        }
        if (configuration() != null) {
            sb.append("Configuration: ").append(configuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeActivityTypeResponse> {
        /**
         * <p>
         * General information about the activity type.
         * </p>
         * <p>
         * The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
         * </p>
         * <ul>
         * <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be running.</li>
         * <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateActivityType</a>, but is still in use. You
         * should keep workers supporting this type running. You cannot create new tasks of this type.</li>
         * </ul>
         * 
         * @param typeInfo
         *        General information about the activity type.</p>
         *        <p>
         *        The status of activity type (returned in the ActivityTypeInfo structure) can be one of the following.
         *        </p>
         *        <ul>
         *        <li><b>REGISTERED</b>: The type is registered and available. Workers supporting this type should be
         *        running.</li>
         *        <li><b>DEPRECATED</b>: The type was deprecated using <a>DeprecateActivityType</a>, but is still in
         *        use. You should keep workers supporting this type running. You cannot create new tasks of this type.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeInfo(ActivityTypeInfo typeInfo);

        /**
         * <p>
         * The configuration settings registered with the activity type.
         * </p>
         * 
         * @param configuration
         *        The configuration settings registered with the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ActivityTypeConfiguration configuration);
    }

    private static final class BuilderImpl implements Builder {
        private ActivityTypeInfo typeInfo;

        private ActivityTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivityTypeResponse model) {
            setTypeInfo(model.typeInfo);
            setConfiguration(model.configuration);
        }

        public final ActivityTypeInfo getTypeInfo() {
            return typeInfo;
        }

        @Override
        public final Builder typeInfo(ActivityTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final void setTypeInfo(ActivityTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        public final ActivityTypeConfiguration getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(ActivityTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ActivityTypeConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public DescribeActivityTypeResponse build() {
            return new DescribeActivityTypeResponse(this);
        }
    }
}
