/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeprecateWorkflowTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeprecateWorkflowTypeRequest.Builder, DeprecateWorkflowTypeRequest> {
    private final String domain;

    private final WorkflowType workflowType;

    private DeprecateWorkflowTypeRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.workflowType = builder.workflowType;
    }

    /**
     * <p>
     * The name of the domain in which the workflow type is registered.
     * </p>
     * 
     * @return The name of the domain in which the workflow type is registered.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflow type to deprecate.
     * </p>
     * 
     * @return The workflow type to deprecate.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateWorkflowTypeRequest)) {
            return false;
        }
        DeprecateWorkflowTypeRequest other = (DeprecateWorkflowTypeRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeprecateWorkflowTypeRequest> {
        /**
         * <p>
         * The name of the domain in which the workflow type is registered.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which the workflow type is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflow type to deprecate.
         * </p>
         * 
         * @param workflowType
         *        The workflow type to deprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private WorkflowType workflowType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateWorkflowTypeRequest model) {
            setDomain(model.domain);
            setWorkflowType(model.workflowType);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public DeprecateWorkflowTypeRequest build() {
            return new DeprecateWorkflowTypeRequest(this);
        }
    }
}
